/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSActive;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSRichGroup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPhase
implements IPSElement,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasID,
IPSHasRichGroup {
    private String m_sID;
    private PSRichGroup m_aRich;
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private final List<IPSElement> m_aContent = new ArrayList<IPSElement>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "<phase> has no 'id'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (PSInclude iPSElement : this.m_aIncludes) {
            iPSElement.validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aContent) {
            iPSElement.validateCompletely(iPSErrorHandler);
        }
        if (StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "<phase> has no 'id'");
        }
    }

    @Override
    public boolean isMinimal() {
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        ValueEnforcer.notNull(list, (String)"ForeignElements");
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return CollectionHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return CollectionHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return CollectionHelper.newList(this.m_aIncludes);
    }

    public void addP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull((Object)pSP, (String)"P");
        this.m_aContent.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSP> getAllPs() {
        ArrayList<PSP> arrayList = new ArrayList<PSP>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSP)) continue;
            arrayList.add((PSP)iPSElement);
        }
        return arrayList;
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull((Object)pSLet, (String)"Let");
        this.m_aContent.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSLet> getAllLets() {
        ArrayList<PSLet> arrayList = new ArrayList<PSLet>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            arrayList.add((PSLet)iPSElement);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllLetsAsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)iPSElement;
            linkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return linkedHashMap;
    }

    public void addActive(@Nonnull PSActive pSActive) {
        ValueEnforcer.notNull((Object)pSActive, (String)"Active");
        this.m_aContent.add(pSActive);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSActive> getAllActives() {
        ArrayList<PSActive> arrayList = new ArrayList<PSActive>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSActive)) continue;
            arrayList.add((PSActive)iPSElement);
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<IPSElement> getAllContentElements() {
        return CollectionHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "phase");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        for (IPSElement iPSElement : this.m_aContent) {
            microElement.appendChild((IMicroNode)iPSElement.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotEmpty("includes", this.m_aIncludes).appendIfNotEmpty("content", this.m_aContent).appendIfNotEmpty("foreignAttrs", this.m_aForeignAttrs).appendIfNotEmpty("foreignElements", this.m_aForeignElements).toString();
    }
}

