/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSTitle
implements IPSClonableElement<PSTitle>,
IPSOptionalElement,
IPSHasMixedContent {
    private final List<Object> m_aContent = new ArrayList<Object>();

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement)) continue;
            ((IPSElement)object).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDir> getAllDirs() {
        ArrayList<PSDir> arrayList = new ArrayList<PSDir>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSDir)) continue;
            arrayList.add((PSDir)object);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<Object> getAllContentElements() {
        return CollectionHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "title");
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        return microElement;
    }

    @Nonnull
    public PSTitle getClone() {
        PSTitle pSTitle = new PSTitle();
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                pSTitle.addText((String)object);
                continue;
            }
            if (!(object instanceof PSDir)) continue;
            pSTitle.addDir(((PSDir)object).getClone());
        }
        return pSTitle;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotEmpty("content", this.m_aContent).toString();
    }
}

