/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

public class DefaultSVRLErrorLevelDeterminator
implements ISVRLErrorLevelDeterminator {
    public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;

    @Nonnull
    public IErrorLevel getErrorLevelFromFlag(@Nullable String string) {
        if (string == null) {
            return DEFAULT_ERROR_LEVEL;
        }
        if (string.equalsIgnoreCase("warning") || string.equalsIgnoreCase("warn")) {
            return EErrorLevel.WARN;
        }
        if (string.equalsIgnoreCase("error") || string.equalsIgnoreCase("err")) {
            return EErrorLevel.ERROR;
        }
        if (string.equalsIgnoreCase("fatal") || string.equalsIgnoreCase("fatal_error") || string.equalsIgnoreCase("fatalerror")) {
            return EErrorLevel.FATAL_ERROR;
        }
        throw new IllegalArgumentException("Cannot convert the SVRL failed assertion flag '" + string + "' to an error level. Please extend the preceeding list!");
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        ValueEnforcer.notNull((Object)failedAssert, (String)"FailedAssert");
        return this.getErrorLevelFromFlag(failedAssert.getFlag());
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        ValueEnforcer.notNull((Object)successfulReport, (String)"SuccessfulReport");
        return this.getErrorLevelFromFlag(successfulReport.getFlag());
    }
}

