/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.ISeverityComparable;
import com.helger.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

@ThreadSafe
public final class SVRLHelper {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLHelper s_aInstance = new SVRLHelper();

    private SVRLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLFailedAssert> getAllFailedAssertions(@Nonnull SchematronOutputType schematronOutputType) {
        ArrayList<SVRLFailedAssert> arrayList = new ArrayList<SVRLFailedAssert>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof FailedAssert)) continue;
            arrayList.add(new SVRLFailedAssert((FailedAssert)object));
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        ArrayList<SVRLFailedAssert> arrayList = new ArrayList<SVRLFailedAssert>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLFailedAssert sVRLFailedAssert;
            if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isMoreOrEqualSevereThan((ISeverityComparable)iErrorLevel)) continue;
            arrayList.add(sVRLFailedAssert);
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLSuccessfulReport> getAllSuccessfulReports(@Nonnull SchematronOutputType schematronOutputType) {
        ArrayList<SVRLSuccessfulReport> arrayList = new ArrayList<SVRLSuccessfulReport>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof SuccessfulReport)) continue;
            arrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        ArrayList<SVRLSuccessfulReport> arrayList = new ArrayList<SVRLSuccessfulReport>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLSuccessfulReport sVRLSuccessfulReport;
            if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isMoreOrEqualSevereThan((ISeverityComparable)iErrorLevel)) continue;
            arrayList.add(sVRLSuccessfulReport);
        }
        return arrayList;
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        s_aRWLock.readLock().lock();
        try {
            ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator = s_aELD;
            return iSVRLErrorLevelDeterminator;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setErrorLevelDeterminator(@Nonnull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        ValueEnforcer.notNull((Object)iSVRLErrorLevelDeterminator, (String)"ErrorLevelDeterminator");
        s_aRWLock.readLock().lock();
        try {
            s_aELD = iSVRLErrorLevelDeterminator;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }
}

