/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.error.ResourceError;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import javax.annotation.Nonnull;

public class SVRLResourceError
extends ResourceError {
    private final String m_sTest;

    public SVRLResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nonnull String string2) {
        super(iResourceLocation, iErrorLevel, string, null);
        ValueEnforcer.notNull((Object)string2, (String)"Test");
        this.m_sTest = string2;
    }

    @Nonnull
    public String getTest() {
        return this.m_sTest;
    }

    public String getAsString(@Nonnull Locale locale) {
        String string = "[" + (String)this.getErrorLevel().getID() + "]";
        String string2 = this.getLocation().getAsString();
        if (StringHelper.hasText((String)string2)) {
            string = string + ' ' + string2;
        }
        string = string + "; Test=" + this.m_sTest;
        string = string + "; Message=" + this.getDisplayText(locale);
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SVRLResourceError sVRLResourceError = (SVRLResourceError)((Object)object);
        return this.m_sTest.equals(sVRLResourceError.m_sTest);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sTest).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("test", (Object)this.m_sTest).toString();
    }
}

