/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.xml.transform.TransformSourceFactory;
import com.helger.commons.xml.transform.XMLTransformerFactory;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
final class SchematronProviderXSLTFromSCH
implements ISchematronXSLTBasedProvider {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronProviderXSLTFromSCH.class);
    private static final String SCHEMATRON_DIRECTORY_XSLT2 = "schematron/20100414-xslt2/";
    private static final String XSLT2_STEP1 = "schematron/20100414-xslt2/iso_dsdl_include.xsl";
    private static final String XSLT2_STEP2 = "schematron/20100414-xslt2/iso_abstract_expand.xsl";
    private static final String XSLT2_STEP3 = "schematron/20100414-xslt2/iso_svrl_for_xslt2.xsl";
    private static final boolean SAVE_INTERMEDIATE_FILES = false;
    private static Templates s_aStep1;
    private static Templates s_aStep2;
    private static Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public SchematronProviderXSLTFromSCH(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        this.m_aSchematronResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)sCHTransformerCustomizer, (String)"TransformerCustomizer");
        try {
            if (s_aStep1 == null) {
                s_aStep1 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP1));
            }
            if (s_aStep2 == null) {
                s_aStep2 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP2));
            }
            if (s_aStep3 == null) {
                s_aStep3 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP3));
            }
            DOMResult dOMResult = new DOMResult();
            Transformer transformer = s_aStep1.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_1, transformer);
            transformer.transform((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), dOMResult);
            DOMResult dOMResult2 = new DOMResult();
            Transformer transformer2 = s_aStep2.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_2, transformer2);
            transformer2.transform(TransformSourceFactory.create((Node)dOMResult.getNode()), dOMResult2);
            DOMResult dOMResult3 = new DOMResult();
            Transformer transformer3 = s_aStep3.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_3, transformer3);
            transformer3.transform(TransformSourceFactory.create((Node)dOMResult2.getNode()), dOMResult3);
            this.m_aSchematronXSLTDoc = (Document)dOMResult3.getNode();
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Schematron preprocessor error", throwable);
        }
    }

    @Nonnull
    public IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    @Override
    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Override
    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Override
    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }
}

