/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronResourceSCHCache;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SchematronResourceSCH
extends AbstractSchematronXSLTBasedResource<SchematronResourceSCH> {
    private boolean m_bUseCache = true;
    private String m_sPhase;
    private String m_sLanguageCode;

    public SchematronResourceSCH(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    public boolean isUseCache() {
        return this.m_bUseCache;
    }

    public void setUseCache(boolean bl) {
        this.m_bUseCache = bl;
    }

    @Nullable
    public String getPhase() {
        return this.m_sPhase;
    }

    public void setPhase(@Nullable String string) {
        this.m_sPhase = string;
    }

    @Nullable
    public String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    public void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
    }

    @Nonnull
    @OverrideOnDemand
    protected SCHTransformerCustomizer createTransformerCustomizer() {
        return new SCHTransformerCustomizer().setErrorListener(this.getErrorListener()).setURIResolver(this.getURIResolver()).setParameters(this.getParameters()).setPhase(this.m_sPhase).setLanguageCode(this.m_sLanguageCode);
    }

    @Override
    @Nullable
    public ISchematronXSLTBasedProvider getXSLTProvider() {
        SCHTransformerCustomizer sCHTransformerCustomizer = this.createTransformerCustomizer();
        if (this.m_bUseCache) {
            return SchematronResourceSCHCache.getSchematronXSLTProvider(this.getResource(), sCHTransformerCustomizer);
        }
        return SchematronResourceSCHCache.createSchematronXSLTProvider(this.getResource(), sCHTransformerCustomizer);
    }

    @Nonnull
    public static SchematronResourceSCH fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull File file) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(file));
    }
}

