/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.IResourceError;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.xml.transform.CollectingTransformErrorListener;
import com.helger.commons.xml.transform.LoggingTransformErrorListener;
import com.helger.schematron.xslt.SchematronProviderXSLTPrebuild;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SchematronResourceXSLTCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronResourceXSLTCache.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final Map<String, SchematronProviderXSLTPrebuild> s_aCache = new HashMap<String, SchematronProviderXSLTPrebuild>();

    private SchematronResourceXSLTCache() {
    }

    @Nullable
    public static SchematronProviderXSLTPrebuild createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        CollectingTransformErrorListener collectingTransformErrorListener;
        SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild;
        if (GlobalDebug.isDebugMode() && s_aLogger.isInfoEnabled()) {
            s_aLogger.info("Compiling XSLT instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTPrebuild = new SchematronProviderXSLTPrebuild(iReadableResource, (ErrorListener)(collectingTransformErrorListener = new CollectingTransformErrorListener(errorListener != null ? errorListener : new LoggingTransformErrorListener(Locale.US))), uRIResolver)).isValidSchematron()) {
            s_aLogger.warn("The XSLT resource '" + iReadableResource.getResourceID() + "' is invalid!");
            for (IResourceError iResourceError : collectingTransformErrorListener.getResourceErrors()) {
                s_aLogger.warn("  " + iResourceError.getAsString(Locale.US));
            }
            return null;
        }
        if (schematronProviderXSLTPrebuild.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from XSLT resource '" + iReadableResource.getResourceID() + "'!");
        }
        return schematronProviderXSLTPrebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SchematronProviderXSLTPrebuild getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild;
        ValueEnforcer.notNull((Object)iReadableResource, (String)"resource");
        if (!iReadableResource.exists()) {
            s_aLogger.warn("XSLT resource " + iReadableResource + " does not exist!");
            return null;
        }
        String string = iReadableResource.getResourceID();
        s_aRWLock.readLock().lock();
        try {
            schematronProviderXSLTPrebuild = s_aCache.get(string);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (schematronProviderXSLTPrebuild == null) {
            s_aRWLock.writeLock().lock();
            try {
                schematronProviderXSLTPrebuild = s_aCache.get(string);
                if (schematronProviderXSLTPrebuild == null && (schematronProviderXSLTPrebuild = SchematronResourceXSLTCache.createSchematronXSLTProvider(iReadableResource, errorListener, uRIResolver)) != null) {
                    s_aCache.put(string, schematronProviderXSLTPrebuild);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return schematronProviderXSLTPrebuild;
    }
}

