/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSParam
implements IPSElement {
    private String m_sName;
    private String m_sValue;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sName)) {
            iPSErrorHandler.error(this, "<param> has no 'name'");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sValue)) {
            iPSErrorHandler.error(this, "<param> has no 'value'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sName)) {
            iPSErrorHandler.error(this, "<param> has no 'name'");
        }
        if (StringHelper.hasNoText((String)this.m_sValue)) {
            iPSErrorHandler.error(this, "<param> has no 'value'");
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    public void setName(@Nullable String string) {
        this.m_sName = string;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public void setValue(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("value may not be empty!");
        }
        this.m_sValue = string;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "param");
        microElement.setAttribute("name", this.m_sName);
        microElement.setAttribute("value", this.m_sValue);
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("name", (Object)this.m_sName).appendIfNotNull("value", (Object)this.m_sValue).toString();
    }
}

