/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.commons.CGlobal;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

public final class SchematronTransformerFactory {
    private static final TransformerFactory s_aDefaultFactory = SchematronTransformerFactory.createTransformerFactorySaxonFirst((ErrorListener)new LoggingTransformErrorListener(CGlobal.DEFAULT_LOCALE), (URIResolver)new DefaultTransformURIResolver());

    private SchematronTransformerFactory() {
    }

    @Nonnull
    public static TransformerFactory getDefaultSaxonFirst() {
        return s_aDefaultFactory;
    }

    @Nonnull
    public static TransformerFactory createTransformerFactorySaxonFirst(@Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", ClassLoaderHelper.getContextClassLoader());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            try {
                transformerFactory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError2) {
                throw new InitializationException("Failed to create XML TransformerFactory", (Throwable)transformerFactoryConfigurationError2);
            }
        }
        if (errorListener != null) {
            transformerFactory.setErrorListener(errorListener);
        }
        if (uRIResolver != null) {
            transformerFactory.setURIResolver(uRIResolver);
        }
        return transformerFactory;
    }
}

