/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IErrorLevel;
import com.helger.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

@ThreadSafe
public final class SVRLHelper {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLHelper s_aInstance = new SVRLHelper();

    private SVRLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertions(@Nonnull SchematronOutputType schematronOutputType) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof FailedAssert)) continue;
            commonsArrayList.add((Object)new SVRLFailedAssert((FailedAssert)object));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLFailedAssert sVRLFailedAssert;
            if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isMoreOrEqualSevereThan(iErrorLevel)) continue;
            commonsArrayList.add((Object)sVRLFailedAssert);
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReports(@Nonnull SchematronOutputType schematronOutputType) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof SuccessfulReport)) continue;
            commonsArrayList.add((Object)new SVRLSuccessfulReport((SuccessfulReport)object));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull IErrorLevel iErrorLevel) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLSuccessfulReport sVRLSuccessfulReport;
            if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isMoreOrEqualSevereThan(iErrorLevel)) continue;
            commonsArrayList.add((Object)sVRLSuccessfulReport);
        }
        return commonsArrayList;
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    @Nonnull
    public static IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    @Nonnull
    public static ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        return (ISVRLErrorLevelDeterminator)s_aRWLock.readLocked(() -> s_aELD);
    }

    public static void setErrorLevelDeterminator(@Nonnull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        ValueEnforcer.notNull((Object)iSVRLErrorLevelDeterminator, (String)"ErrorLevelDeterminator");
        s_aRWLock.readLocked(() -> {
            s_aELD = iSVRLErrorLevelDeterminator;
            return s_aELD;
        });
    }
}

