/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.svrl.SVRLReader;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.validator.ISchematronXSLTValidator;
import com.helger.schematron.xslt.validator.SchematronXSLTValidatorDefault;
import com.helger.xml.XMLFactory;
import com.helger.xml.transform.LoggingTransformErrorListener;
import com.helger.xml.transform.TransformSourceFactory;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractSchematronXSLTBasedResource<IMPLTYPE extends AbstractSchematronXSLTBasedResource<IMPLTYPE>>
extends AbstractSchematronResource
implements IGenericImplTrait<IMPLTYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractSchematronXSLTBasedResource.class);
    protected ErrorListener m_aCustomErrorListener;
    protected URIResolver m_aCustomURIResolver;
    protected ICommonsOrderedMap<String, ?> m_aCustomParameters;
    private ISchematronXSLTValidator m_aXSLTValidator = new SchematronXSLTValidatorDefault();

    public AbstractSchematronXSLTBasedResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Nullable
    public ErrorListener getErrorListener() {
        return this.m_aCustomErrorListener;
    }

    @Nonnull
    public IMPLTYPE setErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aCustomErrorListener = errorListener;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Nullable
    public URIResolver getURIResolver() {
        return this.m_aCustomURIResolver;
    }

    @Nonnull
    public IMPLTYPE setURIResolver(@Nullable URIResolver uRIResolver) {
        this.m_aCustomURIResolver = uRIResolver;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    public boolean hasParameters() {
        return this.m_aCustomParameters != null && this.m_aCustomParameters.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ?> getParameters() {
        return new CommonsLinkedHashMap(this.m_aCustomParameters);
    }

    @Nonnull
    public IMPLTYPE setParameters(@Nullable Map<String, ?> map) {
        this.m_aCustomParameters = new CommonsLinkedHashMap(map);
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Nullable
    public abstract ISchematronXSLTBasedProvider getXSLTProvider();

    @Nonnull
    public ISchematronXSLTValidator getXSLTValidator() {
        return this.m_aXSLTValidator;
    }

    @Nonnull
    public IMPLTYPE setXSLTValidator(@Nonnull ISchematronXSLTValidator iSchematronXSLTValidator) {
        ValueEnforcer.notNull((Object)iSchematronXSLTValidator, (String)"XSLTValidator");
        this.m_aXSLTValidator = iSchematronXSLTValidator;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    public final boolean isValidSchematron() {
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        return iSchematronXSLTBasedProvider != null && iSchematronXSLTBasedProvider.isValidSchematron();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"XMLResource");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            s_aLogger.warn("XML resource " + iHasInputStream + " does not exist!");
            return EValidity.INVALID;
        }
        try {
            EValidity eValidity = this.getSchematronValidity(TransformSourceFactory.create((InputStream)inputStream));
            return eValidity;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Source source) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(source);
        if (schematronOutputType == null) {
            return EValidity.INVALID;
        }
        return this.m_aXSLTValidator.getSchematronValidity(schematronOutputType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"XMLResource");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            s_aLogger.warn("XML resource " + iHasInputStream + " does not exist!");
            return null;
        }
        try {
            Document document = this.applySchematronValidation(TransformSourceFactory.create((InputStream)inputStream));
            return document;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nullable
    public Document applySchematronValidation(@Nonnull Node node) throws Exception {
        ValueEnforcer.notNull((Object)node, (String)"XMLResource");
        return this.applySchematronValidation(TransformSourceFactory.create((Node)node));
    }

    @Override
    @Nullable
    public final Document applySchematronValidation(@Nonnull Source source) throws TransformerException {
        ValueEnforcer.notNull((Object)source, (String)"XMLSource");
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        if (iSchematronXSLTBasedProvider == null || !iSchematronXSLTBasedProvider.isValidSchematron()) {
            return null;
        }
        Document document = XMLFactory.newDocument();
        Transformer transformer = iSchematronXSLTBasedProvider.getXSLTTransformer();
        if (this.m_aCustomErrorListener != null) {
            transformer.setErrorListener(this.m_aCustomErrorListener);
        } else {
            transformer.setErrorListener((ErrorListener)new LoggingTransformErrorListener(Locale.US));
        }
        if (this.m_aCustomURIResolver != null) {
            transformer.setURIResolver(this.m_aCustomURIResolver);
        }
        if (this.m_aCustomParameters != null) {
            for (Map.Entry entry : this.m_aCustomParameters.entrySet()) {
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        transformer.transform(source, new DOMResult(document));
        return document;
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        Document document = this.applySchematronValidation(iHasInputStream);
        return document == null ? null : SVRLReader.readXML(document);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Source source) throws Exception {
        Document document = this.applySchematronValidation(source);
        return document == null ? null : SVRLReader.readXML(document);
    }

    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Node node) throws Exception {
        Document document = this.applySchematronValidation(node);
        return document == null ? null : SVRLReader.readXML(document);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("XSLTValidator", (Object)this.m_aXSLTValidator).toString();
    }
}

