/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronProviderXSLTFromSCH;
import com.helger.xml.serialize.write.XMLWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class SchematronResourceSCHCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronResourceSCHCache.class);
    private static final Lock s_aLock = new ReentrantLock();
    private static final ICommonsMap<String, SchematronProviderXSLTFromSCH> s_aCache = new CommonsHashMap();

    private SchematronResourceSCHCache() {
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH;
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Compiling Schematron instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTFromSCH = new SchematronProviderXSLTFromSCH(iReadableResource, sCHTransformerCustomizer)).isValidSchematron()) {
            s_aLogger.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (GlobalDebug.isDebugMode() && schematronProviderXSLTFromSCH.getXSLTDocument() != null) {
                s_aLogger.warn("  Created XSLT document:\n" + XMLWriter.getXMLString((Node)schematronProviderXSLTFromSCH.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSCH.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        return schematronProviderXSLTFromSCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SchematronProviderXSLTFromSCH getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)sCHTransformerCustomizer, (String)"TransformerCustomizer");
        if (!iReadableResource.exists()) {
            s_aLogger.warn("Schematron resource " + iReadableResource + " does not exist!");
            return null;
        }
        if (!sCHTransformerCustomizer.canCacheResult()) {
            return SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer);
        }
        String string = StringHelper.getImploded((char)':', (Object[])new String[]{iReadableResource.getResourceID(), StringHelper.getNotNull((String)sCHTransformerCustomizer.getPhase()), StringHelper.getNotNull((String)sCHTransformerCustomizer.getLanguageCode())});
        s_aLock.lock();
        try {
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = (SchematronProviderXSLTFromSCH)s_aCache.get((Object)string);
            if (schematronProviderXSLTFromSCH == null && (schematronProviderXSLTFromSCH = SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer)) != null) {
                s_aCache.put((Object)string, (Object)schematronProviderXSLTFromSCH);
            }
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH2 = schematronProviderXSLTFromSCH;
            return schematronProviderXSLTFromSCH2;
        }
        finally {
            s_aLock.unlock();
        }
    }
}

