/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPattern
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private boolean m_bAbstract = false;
    private String m_sID;
    private String m_sIsA;
    private PSRichGroup m_aRich;
    private final ICommonsList<PSInclude> m_aIncludes = new CommonsArrayList();
    private PSTitle m_aTitle;
    private final ICommonsList<IPSElement> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;
    private ICommonsList<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sIsA)) {
            for (IPSElement iPSElement : this.m_aContent) {
                if (!(iPSElement instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
                return false;
            }
        } else {
            for (IPSElement iPSElement : this.m_aContent) {
                if (iPSElement instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                    return false;
                }
                if (!(iPSElement instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
                return false;
            }
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            if (((PSInclude)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isValid(iPSErrorHandler)) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
        }
        if (StringHelper.hasNoText((String)this.m_sIsA)) {
            for (IPSElement iPSElement : this.m_aContent) {
                if (!(iPSElement instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
            }
        } else {
            for (IPSElement iPSElement : this.m_aContent) {
                if (iPSElement instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                }
                if (!(iPSElement instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
            }
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            ((PSInclude)iPSElement).validateCompletely(iPSErrorHandler);
        }
        if (this.m_aTitle != null) {
            this.m_aTitle.validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aContent) {
            iPSElement.validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        if (this.m_bAbstract) {
            return false;
        }
        if (StringHelper.hasText((String)this.m_sIsA)) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            if (((PSInclude)iPSElement).isMinimal()) continue;
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isMinimal()) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new CommonsArrayList();
        }
        this.m_aForeignElements.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && this.m_aForeignElements.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return new CommonsArrayList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setIsA(@Nullable String string) {
        this.m_sIsA = string;
    }

    @Nullable
    public String getIsA() {
        return this.m_sIsA;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aIncludes.add((Object)pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aIncludes.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return (ICommonsList)this.m_aIncludes.getClone();
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aTitle = pSTitle;
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aTitle;
    }

    public boolean hasTitle() {
        return this.m_aTitle != null;
    }

    public void addRule(@Nonnull PSRule pSRule) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        this.m_aContent.add((Object)pSRule);
    }

    @Nullable
    public PSRule getRuleOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (IPSElement iPSElement : this.m_aContent) {
                PSRule pSRule;
                if (!(iPSElement instanceof PSRule) || !string.equals((pSRule = (PSRule)iPSElement).getID())) continue;
                return pSRule;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSRule> getAllRules() {
        return this.m_aContent.getAllInstanceOf(PSRule.class);
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aContent.getCount(iPSElement -> iPSElement instanceof PSRule);
    }

    public void addParam(@Nonnull PSParam pSParam) {
        ValueEnforcer.notNull((Object)pSParam, (String)"Param");
        this.m_aContent.add((Object)pSParam);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSParam> getAllParams() {
        return this.m_aContent.getAllInstanceOf(PSParam.class);
    }

    public boolean hasAnyParam() {
        return this.m_aContent.containsAny(iPSElement -> iPSElement instanceof PSParam);
    }

    public void addP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull((Object)pSP, (String)"P");
        this.m_aContent.add((Object)pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllPs() {
        return this.m_aContent.getAllInstanceOf(PSP.class);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull((Object)pSLet, (String)"Let");
        this.m_aContent.add((Object)pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aContent.containsAny(iPSElement -> iPSElement instanceof PSLet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return this.m_aContent.getAllInstanceOf(PSLet.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)iPSElement;
            commonsLinkedHashMap.put((Object)pSLet.getName(), (Object)pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPSElement> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "pattern");
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("is-a", this.m_sIsA);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (Object object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)((PSInclude)object).getAsMicroElement());
        }
        if (this.m_aTitle != null) {
            microElement.appendChild((IMicroNode)this.m_aTitle.getAsMicroElement());
        }
        for (Object object : this.m_aContent) {
            microElement.appendChild((IMicroNode)object.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("abstract", this.m_bAbstract).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("is-a", (Object)this.m_sIsA).appendIfNotNull("rich", (Object)this.m_aRich).appendIf("includes", this.m_aIncludes, CollectionHelper::isNotEmpty).appendIfNotNull("title", (Object)this.m_aTitle).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).appendIf("foreignElements", this.m_aForeignElements, CollectionHelper::isNotEmpty).getToString();
    }
}

