/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.StringHelper;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.om.NamespaceResolver;

public final class SaxonNamespaceContext
implements NamespaceContext,
NamespaceResolver {
    private final MapBasedNamespaceContext m_aCtx;

    public SaxonNamespaceContext(@Nonnull MapBasedNamespaceContext mapBasedNamespaceContext) {
        this.m_aCtx = (MapBasedNamespaceContext)ValueEnforcer.notNull((Object)mapBasedNamespaceContext, (String)"Ctx");
    }

    @Nullable
    public String getURIForPrefix(@Nullable String string, boolean bl) {
        if (bl && StringHelper.hasNoText((String)string)) {
            return this.m_aCtx.getDefaultNamespaceURI();
        }
        return this.m_aCtx.getCustomNamespaceURI(string);
    }

    @Nonnull
    public Iterator<String> iteratePrefixes() {
        CommonsArrayList commonsArrayList = new CommonsArrayList((Collection)this.m_aCtx.getPrefixToNamespaceURIMap().keySet());
        commonsArrayList.add((Object)"");
        return commonsArrayList.iterator();
    }

    @Override
    @Nonnull
    public String getNamespaceURI(@Nonnull String string) {
        return this.m_aCtx.getNamespaceURI(string);
    }

    @Override
    @Nullable
    public String getPrefix(@Nonnull String string) {
        return this.m_aCtx.getPrefix(string);
    }

    @Nonnull
    public Iterator<?> getPrefixes(@Nonnull String string) {
        return this.m_aCtx.getPrefixes(string);
    }
}

