/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.functional.IFunction;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSVRLErrorLevelDeterminator
implements ISVRLErrorLevelDeterminator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DefaultSVRLErrorLevelDeterminator.class);
    public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;
    public static final IFunction<String, IErrorLevel> UNKNOWN_ERROR_LEVEL_HANDLER = (IFunction & Serializable)string -> {
        if (string != null) {
            s_aLogger.warn("Cannot convert the SVRL flag '" + string + "' to an error level. Using default error level instead!");
        }
        return DEFAULT_ERROR_LEVEL;
    };
    private final IFunction<String, ? extends IErrorLevel> m_aUnknwownErrorLevelHandler;

    public DefaultSVRLErrorLevelDeterminator() {
        this(UNKNOWN_ERROR_LEVEL_HANDLER);
    }

    public DefaultSVRLErrorLevelDeterminator(@Nonnull IFunction<String, ? extends IErrorLevel> iFunction) {
        this.m_aUnknwownErrorLevelHandler = (IFunction)ValueEnforcer.notNull(iFunction, (String)"UnknwownErrorLevelHandler");
    }

    @Nonnull
    public IFunction<String, ? extends IErrorLevel> getUnknwownErrorLevelHandler() {
        return this.m_aUnknwownErrorLevelHandler;
    }

    @Nullable
    public static IErrorLevel getDefaultErrorLevelFromString(@Nullable String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("information") || string.equalsIgnoreCase("info") || string.equalsIgnoreCase("notice") || string.equalsIgnoreCase("note")) {
                return EErrorLevel.INFO;
            }
            if (string.equalsIgnoreCase("warning") || string.equalsIgnoreCase("warn")) {
                return EErrorLevel.WARN;
            }
            if (string.equalsIgnoreCase("error") || string.equalsIgnoreCase("err")) {
                return EErrorLevel.ERROR;
            }
            if (string.equalsIgnoreCase("fatal") || string.equalsIgnoreCase("fatal_error") || string.equalsIgnoreCase("fatal-error") || string.equalsIgnoreCase("fatalerror")) {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevelFromString(@Nullable String string) {
        IErrorLevel iErrorLevel = DefaultSVRLErrorLevelDeterminator.getDefaultErrorLevelFromString(string);
        if (iErrorLevel != null) {
            return iErrorLevel;
        }
        return (IErrorLevel)this.m_aUnknwownErrorLevelHandler.apply((Object)string);
    }
}

