/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.schematron.svrl.ISVRLLocationBeautifierSPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class SVRLLocationBeautifierRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SVRLLocationBeautifierRegistry.class);
    private static final ICommonsList<ISVRLLocationBeautifierSPI> s_aList = ServiceLoaderHelper.getAllSPIImplementations(ISVRLLocationBeautifierSPI.class);
    private static final SVRLLocationBeautifierRegistry s_aInstance = new SVRLLocationBeautifierRegistry();

    private SVRLLocationBeautifierRegistry() {
    }

    @Nullable
    public static String getBeautifiedLocation(@Nonnull String string, @Nonnull String string2) {
        for (ISVRLLocationBeautifierSPI iSVRLLocationBeautifierSPI : s_aList) {
            String string3 = iSVRLLocationBeautifierSPI.getReplacementText(string, string2);
            if (string3 == null) continue;
            return string3;
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Unsupported elements for beautification: " + string + " -- " + string2);
        }
        return null;
    }
}

