/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IError;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.xslt.SchematronProviderXSLTPrebuild;
import com.helger.xml.transform.CollectingTransformErrorListener;
import com.helger.xml.transform.LoggingTransformErrorListener;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SchematronResourceXSLTCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceXSLTCache.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, SchematronProviderXSLTPrebuild> s_aCache = new CommonsHashMap();

    private SchematronResourceXSLTCache() {
    }

    @Nullable
    public static SchematronProviderXSLTPrebuild createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        CollectingTransformErrorListener collectingTransformErrorListener;
        SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Compiling XSLT instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTPrebuild = new SchematronProviderXSLTPrebuild(iReadableResource, (ErrorListener)(collectingTransformErrorListener = new CollectingTransformErrorListener()).andThen(errorListener != null ? errorListener : new LoggingTransformErrorListener(Locale.US)), uRIResolver)).isValidSchematron()) {
            LOGGER.warn("The XSLT resource '" + iReadableResource.getResourceID() + "' is invalid!");
            for (IError iError : collectingTransformErrorListener.getErrorList()) {
                LOGGER.warn("  " + iError.getAsString(Locale.US));
            }
            return null;
        }
        if (schematronProviderXSLTPrebuild.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from XSLT resource '" + iReadableResource.getResourceID() + "'!");
        }
        return schematronProviderXSLTPrebuild;
    }

    @Nullable
    public static SchematronProviderXSLTPrebuild getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"resource");
        if (!iReadableResource.exists()) {
            LOGGER.warn("XSLT resource " + iReadableResource + " does not exist!");
            return null;
        }
        String string = iReadableResource.getResourceID();
        SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild = (SchematronProviderXSLTPrebuild)s_aRWLock.readLocked(() -> (SchematronProviderXSLTPrebuild)s_aCache.get((Object)string));
        if (schematronProviderXSLTPrebuild != null) {
            return schematronProviderXSLTPrebuild;
        }
        return (SchematronProviderXSLTPrebuild)s_aRWLock.writeLocked(() -> {
            SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild = (SchematronProviderXSLTPrebuild)s_aCache.get((Object)string);
            if (schematronProviderXSLTPrebuild == null && (schematronProviderXSLTPrebuild = SchematronResourceXSLTCache.createSchematronXSLTProvider(iReadableResource, errorListener, uRIResolver)) != null) {
                s_aCache.put((Object)string, (Object)schematronProviderXSLTPrebuild);
            }
            return schematronProviderXSLTPrebuild;
        });
    }
}

