/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasFlag;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasLinkableGroup;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSExtends;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSLinkableGroup;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSRule
implements IPSElement,
IPSHasID,
IPSHasFlag,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup,
IPSHasLinkableGroup {
    public static final boolean DEFAULT_ABSTRACT = false;
    private String m_sFlag;
    private PSRichGroup m_aRich;
    private PSLinkableGroup m_aLinkable;
    private boolean m_bAbstract = false;
    private String m_sContext;
    private String m_sID;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <rule> has no 'id'");
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sContext)) {
            iPSErrorHandler.error(this, "abstract <rule> may not have a 'context'");
            return false;
        }
        if (!this.m_bAbstract && StringHelper.hasNoText((String)this.m_sContext)) {
            iPSErrorHandler.error(this, "<rule> must have a 'context'");
            return false;
        }
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<rule> has no content");
            return false;
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <rule> has no 'id'");
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sContext)) {
            iPSErrorHandler.error(this, "abstract <rule> may not have a 'context'");
        }
        if (!this.m_bAbstract && StringHelper.hasNoText((String)this.m_sContext)) {
            iPSErrorHandler.error(this, "<rule> must have a 'context'");
        }
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<rule> has no content");
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    public void setFlag(@Nullable String string) {
        this.m_sFlag = string;
    }

    @Override
    @Nullable
    public String getFlag() {
        return this.m_sFlag;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void setLinkable(@Nullable PSLinkableGroup pSLinkableGroup) {
        this.m_aLinkable = pSLinkableGroup;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkable() {
        return this.m_aLinkable;
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    public void setContext(@Nullable String string) {
        this.m_sContext = string;
    }

    @Nullable
    public String getContext() {
        return this.m_sContext;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aContent.add((Object)pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aContent.containsAny(object -> object instanceof PSInclude);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return this.m_aContent.getAllInstanceOf(PSInclude.class);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull((Object)pSLet, (String)"Let");
        this.m_aContent.add((Object)pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aContent.containsAny(object -> object instanceof PSLet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return this.m_aContent.getAllInstanceOf(PSLet.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Object e : this.m_aContent) {
            if (!(e instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)e;
            commonsLinkedHashMap.put((Object)pSLet.getName(), (Object)pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    public void addAssertReport(@Nonnull PSAssertReport pSAssertReport) {
        ValueEnforcer.notNull((Object)pSAssertReport, (String)"AssertReport");
        this.m_aContent.add((Object)pSAssertReport);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSAssertReport> getAllAssertReports() {
        return this.m_aContent.getAllInstanceOf(PSAssertReport.class);
    }

    public void addExtends(@Nonnull PSExtends pSExtends) {
        ValueEnforcer.notNull((Object)pSExtends, (String)"Extends");
        this.m_aContent.add((Object)pSExtends);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSExtends> getAllExtends() {
        return this.m_aContent.getAllInstanceOf(PSExtends.class);
    }

    @Nonnegative
    public int getExtendsCount() {
        return this.m_aContent.getCount(object -> object instanceof PSExtends);
    }

    public boolean hasAnyExtends() {
        return this.m_aContent.containsAny(object -> object instanceof PSExtends);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPSElement> getAllContentElements() {
        return this.m_aContent.getAllMapped(object -> object instanceof IPSElement && !(object instanceof PSInclude) && !(object instanceof PSLet), object -> (IPSElement)object);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "rule");
        microElement.setAttribute("flag", this.m_sFlag);
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("context", this.m_sContext);
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aLinkable != null) {
            this.m_aLinkable.fillMicroElement((IMicroElement)microElement);
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("flag", (Object)this.m_sFlag).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("linkable", (Object)this.m_aLinkable).append("abstract", this.m_bAbstract).appendIfNotNull("context", (Object)this.m_sContext).appendIfNotNull("id", (Object)this.m_sID).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

