/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformSourceFactory;
import com.helger.xml.transform.XMLTransformerFactory;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTFromSCH
implements ISchematronXSLTBasedProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronProviderXSLTFromSCH.class);
    public static final String SCHEMATRON_DIRECTORY_XSLT2 = "schematron/20100710-xslt2/";
    public static final String XSLT2_STEP1 = "schematron/20100710-xslt2/iso_dsdl_include.xsl";
    public static final String XSLT2_STEP2 = "schematron/20100710-xslt2/iso_abstract_expand.xsl";
    public static final String XSLT2_STEP3 = "schematron/20100710-xslt2/iso_svrl_for_xslt2.xsl";
    private static volatile Templates s_aStep1;
    private static volatile Templates s_aStep2;
    private static volatile Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public static void cacheXSLTTemplates() {
        if (s_aStep1 == null) {
            TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating XSLT step 1 template");
            }
            if ((s_aStep1 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP1, SchematronProviderXSLTFromSCH.class.getClassLoader()))) == null) {
                throw new IllegalStateException("Failed to compile 'schematron/20100710-xslt2/iso_dsdl_include.xsl'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating XSLT step 2 template");
            }
            if ((s_aStep2 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP2, SchematronProviderXSLTFromSCH.class.getClassLoader()))) == null) {
                throw new IllegalStateException("Failed to compile 'schematron/20100710-xslt2/iso_abstract_expand.xsl'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating XSLT step 3 template");
            }
            if ((s_aStep3 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP3, SchematronProviderXSLTFromSCH.class.getClassLoader()))) == null) {
                throw new IllegalStateException("Failed to compile 'schematron/20100710-xslt2/iso_svrl_for_xslt2.xsl'");
            }
        }
    }

    public SchematronProviderXSLTFromSCH(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        this.m_aSchematronResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)sCHTransformerCustomizer, (String)"TransformerCustomizer");
        try {
            Object object;
            Object object2;
            Object object3;
            SchematronProviderXSLTFromSCH.cacheXSLTTemplates();
            DOMResult dOMResult = new DOMResult();
            Transformer transformer = s_aStep1.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_1, transformer);
            transformer.transform((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), dOMResult);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished applying XSLT step 1 on " + iReadableResource);
            }
            DOMResult dOMResult2 = new DOMResult();
            Transformer transformer2 = s_aStep2.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_2, transformer2);
            transformer2.transform(TransformSourceFactory.create((Node)dOMResult.getNode()), dOMResult2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished applying XSLT step 2 on " + iReadableResource);
            }
            if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
                object3 = XMLWriter.getNodeAsString((Node)dOMResult2.getNode());
                object2 = new File(SchematronDebug.getIntermediateMinifiedSCHFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".min-xslt.sch");
                if (SimpleFileIO.writeFile((File)object2, (String)object3, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                    LOGGER.info("Successfully wrote intermediate XSLT file '" + ((File)object2).getAbsolutePath() + "'");
                } else {
                    LOGGER.error("Failed to wrote intermediate XSLT file '" + ((File)object2).getAbsolutePath() + "'");
                }
            }
            object3 = new DOMResult();
            object2 = s_aStep3.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_3, (Transformer)object2);
            ((Transformer)object2).transform(TransformSourceFactory.create((Node)dOMResult2.getNode()), (Result)object3);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished applying XSLT step 3 on " + iReadableResource);
            }
            this.m_aSchematronXSLTDoc = (Document)((DOMResult)object3).getNode();
            if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
                object = XMLWriter.getNodeAsString((Node)this.m_aSchematronXSLTDoc);
                File file = new File(SchematronDebug.getIntermediateFinalXSLTFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".xslt");
                if (SimpleFileIO.writeFile((File)file, (String)object, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                    LOGGER.info("Successfully wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
                } else {
                    LOGGER.error("Failed to wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
                }
            }
            object = SchematronTransformerFactory.getDefaultSaxonFirst();
            sCHTransformerCustomizer.customize((TransformerFactory)object);
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((TransformerFactory)object, (Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
        }
        catch (Throwable throwable) {
            LOGGER.error("Schematron preprocessor error", throwable);
        }
    }

    @Nonnull
    public IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    @Override
    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Override
    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Override
    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }
}

