/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronResourceSCHCache;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SchematronResourceSCH
extends AbstractSchematronXSLTBasedResource<SchematronResourceSCH> {
    private String m_sPhase;
    private String m_sLanguageCode;
    private boolean m_bForceCacheResult = false;

    public SchematronResourceSCH(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    public final void setPhase(@Nullable String string) {
        this.m_sPhase = string;
    }

    @Nullable
    public final String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    public final void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
    }

    public final boolean isForceCacheResult() {
        return this.m_bForceCacheResult;
    }

    public final void setForceCacheResult(boolean bl) {
        this.m_bForceCacheResult = bl;
    }

    @Nonnull
    @OverrideOnDemand
    protected SCHTransformerCustomizer createTransformerCustomizer() {
        return new SCHTransformerCustomizer().setErrorListener(this.getErrorListener()).setURIResolver(this.getURIResolver()).setParameters((Map<String, ?>)this.parameters()).setPhase(this.m_sPhase).setLanguageCode(this.m_sLanguageCode).setForceCacheResult(this.m_bForceCacheResult);
    }

    @Override
    @Nullable
    public ISchematronXSLTBasedProvider getXSLTProvider() {
        SCHTransformerCustomizer sCHTransformerCustomizer = this.createTransformerCustomizer();
        if (this.isUseCache()) {
            return SchematronResourceSCHCache.getSchematronXSLTProvider(this.getResource(), sCHTransformerCustomizer);
        }
        return SchematronResourceSCHCache.createSchematronXSLTProvider(this.getResource(), sCHTransformerCustomizer);
    }

    @Nonnull
    public static SchematronResourceSCH fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull File file) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(file));
    }
}

