/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MessageDigestValue
implements Serializable {
    private final EMessageDigestAlgorithm m_eAlgorithm;
    private final byte[] m_aDigestBytes;

    public MessageDigestValue(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull @Nonempty byte[] byArray) {
        this.m_eAlgorithm = (EMessageDigestAlgorithm)((Object)ValueEnforcer.notNull((Object)((Object)eMessageDigestAlgorithm), (String)"Algorithm"));
        this.m_aDigestBytes = ArrayHelper.getCopy((byte[])ValueEnforcer.notEmpty((byte[])byArray, (String)"DigestBytes"));
    }

    @Nonnull
    public EMessageDigestAlgorithm getAlgorithm() {
        return this.m_eAlgorithm;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aDigestBytes);
    }

    public void writeDigestBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        outputStream.write(this.m_aDigestBytes, 0, this.m_aDigestBytes.length);
    }

    @Nonnull
    @Nonempty
    public String getHexEncodedDigestString() {
        return StringHelper.getHexEncoded((byte[])this.m_aDigestBytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MessageDigestValue messageDigestValue = (MessageDigestValue)object;
        return this.m_eAlgorithm.equals((Object)messageDigestValue.m_eAlgorithm) && EqualsHelper.equals((Object)this.m_aDigestBytes, (Object)messageDigestValue.m_aDigestBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eAlgorithm).append(this.m_aDigestBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("algorithm", (Enum)this.m_eAlgorithm).append("bytes", (Object)Arrays.toString(this.m_aDigestBytes)).getToString();
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull byte[] byArray, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        messageDigest.update(byArray);
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest());
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull @WillClose InputStream inputStream, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) throws IOException {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        StreamHelper.readUntilEOF((InputStream)inputStream, (byArray, n) -> messageDigest.update((byte[])byArray, 0, n));
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest());
    }
}

