/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.io.IHasByteArray;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MessageDigestValue
implements IHasByteArray,
Serializable {
    public static final boolean DEFAULT_COPY_NEEDED = true;
    private final EMessageDigestAlgorithm m_eAlgorithm;
    private final ByteArrayWrapper m_aBytes;

    public MessageDigestValue(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull @Nonempty byte[] byArray) {
        this(eMessageDigestAlgorithm, byArray, true);
    }

    public MessageDigestValue(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull @Nonempty byte[] byArray, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eMessageDigestAlgorithm), (String)"Algorithm");
        ValueEnforcer.notEmpty((byte[])byArray, (String)"DigestBytes");
        this.m_eAlgorithm = eMessageDigestAlgorithm;
        this.m_aBytes = new ByteArrayWrapper(byArray, bl);
    }

    @Nonnull
    public EMessageDigestAlgorithm getAlgorithm() {
        return this.m_eAlgorithm;
    }

    public boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Nonnull
    @Deprecated
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes() {
        return this.getAllBytes();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Nonnegative
    public int size() {
        return this.m_aBytes.size();
    }

    @Nonnegative
    public int getOffset() {
        return 0;
    }

    @Deprecated
    public void writeDigestBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        this.m_aBytes.writeTo(outputStream);
    }

    @Nonnull
    @Nonempty
    public String getHexEncodedDigestString() {
        return this.m_aBytes.getHexEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MessageDigestValue messageDigestValue = (MessageDigestValue)object;
        return this.m_eAlgorithm.equals((Object)messageDigestValue.m_eAlgorithm) && this.m_aBytes.equals((Object)messageDigestValue.m_aBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eAlgorithm).append((Object)this.m_aBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Algorithm", (Enum)this.m_eAlgorithm).append("Bytes", (Object)this.m_aBytes).getToString();
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull byte[] byArray, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        messageDigest.update(byArray);
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest(), false);
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull @WillClose InputStream inputStream, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) throws IOException {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        StreamHelper.readUntilEOF((InputStream)inputStream, (byArray, n) -> messageDigest.update((byte[])byArray, 0, n));
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest(), false);
    }
}

