/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.random.RandomHelper;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AuthTokenIDGenerator {
    public static final int DEFAULT_TOKEN_BYTES = 16;

    private AuthTokenIDGenerator() {
    }

    @Nonnull
    public static String generateNewTokenID() {
        return AuthTokenIDGenerator.generateNewTokenID(16);
    }

    @Nonnull
    public static String generateNewTokenID(@Nonnegative int n) {
        byte[] byArray = new byte[n];
        RandomHelper.getRandom().nextBytes(byArray);
        return StringHelper.getHexEncoded((byte[])byArray);
    }
}

