/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.settings.IMutableSettings;
import com.helger.settings.ISettings;
import com.helger.settings.ISettingsAfterChangeCallback;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Settings
implements IMutableSettings {
    private final String m_sName;
    private final ICommonsMap<String, Object> m_aMap = new CommonsHashMap();
    private final CallbackList<ISettingsAfterChangeCallback> m_aAfterChangeCallbacks = new CallbackList();

    public Settings(@Nonnull @Nonempty String string) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public final CallbackList<ISettingsAfterChangeCallback> getAfterChangeCallbackList() {
        return this.m_aAfterChangeCallbacks;
    }

    @Nonnegative
    public int getSize() {
        return this.m_aMap.size();
    }

    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<String> getAllFieldNames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, Object> getAllEntries() {
        return (ICommonsMap)this.m_aMap.getClone();
    }

    @Override
    public void forEach(@Nonnull BiConsumer<? super String, ? super Object> biConsumer) {
        this.m_aMap.forEach(biConsumer);
    }

    @Override
    public void forEach(@Nullable BiPredicate<? super String, ? super Object> biPredicate, @Nonnull BiConsumer<? super String, ? super Object> biConsumer) {
        this.m_aMap.forEach(biPredicate, biConsumer);
    }

    @Override
    public boolean containsField(@Nullable String string) {
        return this.m_aMap.containsKey((Object)string);
    }

    @Override
    @Nullable
    public Object getValue(@Nullable String string) {
        return this.m_aMap.get((Object)string);
    }

    @Override
    @Nullable
    public IMutableSettings getSettingsValue(@Nullable String string) {
        return (IMutableSettings)this.getConvertedValue(string, IMutableSettings.class);
    }

    @Override
    public void restoreValue(@Nonnull @Nonempty String string, @Nonnull Object object) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        ValueEnforcer.notNull((Object)object, (String)"NewValue");
        this.m_aMap.put((Object)string, object);
    }

    @Override
    @Nonnull
    public EChange setValues(@Nonnull ISettings iSettings) {
        ValueEnforcer.notNull((Object)iSettings, (String)"OtherSettings");
        EChange eChange = EChange.UNCHANGED;
        for (String string : iSettings.getAllFieldNames()) {
            eChange = eChange.or((IChangeIndicator)this.setValue(string, iSettings.getValue(string)));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeValue(@Nullable String string) {
        return this.m_aMap.removeObject((Object)string);
    }

    @Override
    @Nonnull
    public EChange clear() {
        return this.m_aMap.removeAll();
    }

    @Override
    @Nonnull
    public EChange setValue(@Nonnull @Nonempty String string, @Nullable Object object) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        Object object2 = this.getValue(string);
        if (EqualsHelper.equals((Object)object2, (Object)object)) {
            return EChange.UNCHANGED;
        }
        if (object == null) {
            this.m_aMap.remove((Object)string);
        } else {
            this.m_aMap.put((Object)string, object);
        }
        this.m_aAfterChangeCallbacks.forEach(iSettingsAfterChangeCallback -> iSettingsAfterChangeCallback.onAfterSettingsChanged(string, object2, object));
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Settings settings = (Settings)object;
        return this.m_sName.equals(settings.m_sName) && EqualsHelper.equals(this.m_aMap, settings.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("name", (Object)this.m_sName).append("map", this.m_aMap).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Settings createFrom(@Nonnull ISettings iSettings) {
        ValueEnforcer.notNull((Object)iSettings, (String)"Other");
        Settings settings = new Settings(iSettings.getName());
        iSettings.forEach((string, object) -> settings.m_aMap.put(string, object));
        return settings;
    }
}

