/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.settings.IMutableSettings;
import com.helger.settings.factory.ISettingsFactory;
import javax.annotation.Nonnull;

public class SettingsCache
extends AbstractNotifyingCache<String, IMutableSettings> {
    private final ISettingsFactory m_aSettingsFactory;

    public SettingsCache(@Nonnull ISettingsFactory iSettingsFactory) {
        super("SettingsCache");
        this.m_aSettingsFactory = (ISettingsFactory)ValueEnforcer.notNull((Object)iSettingsFactory, (String)"SettingsFactory");
    }

    @Nonnull
    public ISettingsFactory getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    protected IMutableSettings getValueToCache(@Nonnull @Nonempty String string) {
        return this.m_aSettingsFactory.apply(string);
    }
}

