/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.settings.IMutableSettingsWithDefault;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SettingsWithDefault
extends Settings
implements IMutableSettingsWithDefault {
    private final ISettings m_aDefaultSettings;

    public SettingsWithDefault(@Nonnull ISettings iSettings) {
        this(iSettings.getName(), iSettings);
    }

    public SettingsWithDefault(@Nonnull @Nonempty String string, @Nonnull ISettings iSettings) {
        super(string);
        this.m_aDefaultSettings = (ISettings)ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
    }

    public boolean containsFieldDirect(@Nullable String string) {
        return super.containsField(string);
    }

    @Override
    public boolean containsField(@Nullable String string) {
        if (this.containsFieldDirect(string)) {
            return true;
        }
        return this.m_aDefaultSettings.containsField(string);
    }

    @Nullable
    public Object getValueDirect(@Nullable String string) {
        return super.getValue(string);
    }

    @Override
    @Nullable
    public Object getValue(@Nullable String string) {
        Object object = this.getValueDirect(string);
        if (object == null) {
            object = this.m_aDefaultSettings.getValue(string);
        }
        return object;
    }

    @Override
    @Nonnull
    public ISettings getDefault() {
        return this.m_aDefaultSettings;
    }

    @Override
    @Nonnull
    public EChange setToDefault(@Nullable String string) {
        Object object = this.m_aDefaultSettings.getValue(string);
        if (object == null) {
            return EChange.UNCHANGED;
        }
        return this.setValue(string, object);
    }

    @Override
    @Nonnull
    public EChange setAllToDefault() {
        EChange eChange = EChange.UNCHANGED;
        for (String string : this.m_aDefaultSettings.getAllFieldNames()) {
            eChange = eChange.or((IChangeIndicator)this.setToDefault(string));
        }
        return eChange;
    }

    @Override
    public boolean isSetToDefault(@Nullable String string) {
        return this.containsFieldDirect(string) && EqualsHelper.equals((Object)this.getValueDirect(string), (Object)this.m_aDefaultSettings.getValue(string));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SettingsWithDefault settingsWithDefault = (SettingsWithDefault)object;
        return this.m_aDefaultSettings.equals(settingsWithDefault.m_aDefaultSettings);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aDefaultSettings).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultSettings", (Object)this.m_aDefaultSettings).getToString();
    }
}

