/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StringInputStream;
import com.helger.commons.state.ESuccess;
import com.helger.settings.IMutableSettings;
import com.helger.settings.ISettings;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public interface ISettingsPersistence {
    @Nonnull
    public Charset getCharset();

    @Nonnull
    default public IMutableSettings readSettings(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Settings");
        return this.readSettings((InputStream)new StringInputStream(string, this.getCharset()));
    }

    @Nonnull
    default public IMutableSettings readSettings(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.readSettings(FileHelper.getInputStream((File)file));
    }

    @Nonnull
    default public IMutableSettings readSettings(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("Failed to open the provided input stream for the settings: " + iHasInputStream);
        }
        return this.readSettings(inputStream);
    }

    @Nullable
    public IMutableSettings readSettings(@Nonnull @WillClose InputStream var1);

    @Nullable
    default public String writeSettings(@Nonnull ISettings iSettings) {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        if (this.writeSettings(iSettings, (OutputStream)nonBlockingByteArrayOutputStream).isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream.getAsString(this.getCharset());
    }

    @Nonnull
    default public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull File file) {
        OutputStream outputStream = FileHelper.getOutputStream((File)file);
        if (outputStream == null) {
            throw new IllegalArgumentException("Failed to open file '" + file.getAbsolutePath() + "' for writing!");
        }
        return this.writeSettings(iSettings, outputStream);
    }

    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings var1, @Nonnull @WillClose OutputStream var2);
}

