/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.configfile;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.traits.IConvertibleByKeyTrait;
import com.helger.commons.ws.WSHelper;
import com.helger.settings.ISettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConfigFile
implements IConvertibleByKeyTrait<String> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConfigFile.class);
    private final IReadableResource m_aReadResource;
    private final ISettings m_aSettings;

    protected ConfigFile(@Nullable IReadableResource iReadableResource, @Nullable ISettings iSettings) {
        this.m_aReadResource = iReadableResource;
        this.m_aSettings = iSettings;
    }

    public boolean isRead() {
        return this.m_aSettings != null;
    }

    @Nullable
    public IReadableResource getReadResource() {
        return this.m_aReadResource;
    }

    @Nullable
    public ISettings getSettings() {
        return this.m_aSettings;
    }

    @Nullable
    public Object getValue(@Nullable String string) {
        return this.m_aSettings == null ? null : this.m_aSettings.getValue(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, Object> getAllEntries() {
        if (this.m_aSettings == null) {
            return new CommonsHashMap();
        }
        return this.m_aSettings.getAllEntries();
    }

    public void applyAsSystemProperties(String ... stringArray) {
        if (this.isRead() && stringArray != null) {
            for (String string : stringArray) {
                String string2 = this.getAsString(string);
                if (string2 == null) continue;
                SystemProperties.setPropertyValue((String)string, (String)string2);
                s_aLogger.info("Set Java system property from configuration: " + string + "=" + string2);
            }
        }
    }

    public void applyAllNetworkSystemProperties() {
        this.applyAsSystemProperties(WSHelper.getAllJavaNetSystemProperties());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ReadResource", (Object)this.m_aReadResource).append("Settings", (Object)this.m_aSettings).getToString();
    }
}

