/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.configfile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceprovider.DefaultResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.settings.IMutableSettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.TrimmedValueSettings;
import com.helger.settings.exchange.properties.SettingsPersistenceProperties;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileBuilder {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConfigFileBuilder.class);
    private ISettingsPersistence m_aSPP = new SettingsPersistenceProperties(string -> new TrimmedValueSettings(string));
    private final ICommonsList<String> m_aPaths = new CommonsArrayList();
    private IReadableResourceProvider m_aResProvider = new DefaultResourceProvider();

    @Nonnull
    public ConfigFileBuilder setSettingsPersistence(@Nonnull ISettingsPersistence iSettingsPersistence) {
        ValueEnforcer.notNull((Object)iSettingsPersistence, (String)"SPP");
        this.m_aSPP = iSettingsPersistence;
        return this;
    }

    @Nonnull
    public ISettingsPersistence getSettingsPersistence() {
        return this.m_aSPP;
    }

    @Nonnull
    public ConfigFileBuilder addPathFromSystemProperty(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SystemPropertyName");
        return this.addPath(() -> SystemProperties.getPropertyValueOrNull((String)string));
    }

    @Nonnull
    public ConfigFileBuilder addPath(@Nonnull Supplier<String> supplier) {
        ValueEnforcer.notNull(supplier, (String)"Supplier");
        return this.addPath(supplier.get());
    }

    @Nonnull
    public ConfigFileBuilder addPath(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.m_aPaths.add((Object)string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder addPaths(String ... stringArray) {
        ValueEnforcer.notNullNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        for (String string : stringArray) {
            this.addPath(string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder addPaths(@Nonnull Iterable<String> iterable) {
        ValueEnforcer.notNullNoNullValue(iterable, (String)"ConfigPaths");
        for (String string : iterable) {
            this.addPath(string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder setPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConfigPath");
        this.m_aPaths.set((Object)string);
        return this;
    }

    @Nonnull
    public ConfigFileBuilder setPaths(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        this.m_aPaths.setAll((Object[])stringArray);
        return this;
    }

    @Nonnull
    public ConfigFileBuilder setPaths(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"ConfigPaths");
        this.m_aPaths.setAll(iterable);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllPaths() {
        return (ICommonsList)this.m_aPaths.getClone();
    }

    @Nonnull
    public ConfigFileBuilder setResourceProvider(@Nonnull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull((Object)iReadableResourceProvider, (String)"ResProvider");
        this.m_aResProvider = iReadableResourceProvider;
        return this;
    }

    @Nonnull
    public IReadableResourceProvider getResourceProvider() {
        return this.m_aResProvider;
    }

    @Nonnull
    public ConfigFile build() {
        InputStream inputStream;
        String string;
        if (this.m_aPaths.isEmpty()) {
            throw new IllegalStateException("No config file path was provided!");
        }
        IReadableResource iReadableResource = null;
        IMutableSettings iMutableSettings = null;
        Iterator iterator = this.m_aPaths.iterator();
        while (iterator.hasNext() && (!this.m_aResProvider.supportsReading(string = (String)iterator.next()) || (iReadableResource = this.m_aResProvider.getReadableResource(string)) == null || (inputStream = iReadableResource.getInputStream()) == null || (iMutableSettings = this.m_aSPP.readSettings(inputStream)) == null)) {
        }
        if (iMutableSettings == null) {
            s_aLogger.warn("Failed to resolve config file paths: " + this.m_aPaths);
        }
        return new ConfigFile(iMutableSettings != null ? iReadableResource : null, iMutableSettings);
    }
}

