/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.GenericReflection;
import com.helger.settings.IMutableSettings;
import com.helger.settings.ISettings;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SettingsMicroDocumentConverter
implements IMicroTypeConverter {
    private static final String ELEMENT_SETTING = "setting";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static final String ELEMENT_VALUE = "value";
    private final ISettingsFactory m_aSettingFactory;

    public SettingsMicroDocumentConverter(@Nonnull ISettingsFactory iSettingsFactory) {
        this.m_aSettingFactory = (ISettingsFactory)ValueEnforcer.notNull((Object)iSettingsFactory, (String)"SettingsFactory");
    }

    @Nonnull
    public ISettingsFactory getSettingsFactory() {
        return this.m_aSettingFactory;
    }

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull String string2) {
        ISettings iSettings = (ISettings)object;
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_NAME, iSettings.getName());
        for (String string3 : iSettings.getAllFieldNames().getSorted(Comparator.naturalOrder())) {
            Object object2 = iSettings.getValue(string3);
            IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_SETTING);
            iMicroElement.setAttribute(ATTR_NAME, string3);
            iMicroElement.setAttribute(ATTR_CLASS, object2.getClass().getName());
            iMicroElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)object2, (String)ELEMENT_VALUE));
        }
        return microElement;
    }

    @Nonnull
    public IMutableSettings convertToNative(IMicroElement iMicroElement2) {
        String string = iMicroElement2.getAttributeValue(ATTR_NAME);
        IMutableSettings iMutableSettings = this.m_aSettingFactory.apply(string);
        iMicroElement2.forAllChildElements(iMicroElement -> {
            String string = iMicroElement.getAttributeValue(ATTR_NAME);
            String string2 = iMicroElement.getAttributeValue(ATTR_CLASS);
            Class clazz = GenericReflection.getClassFromNameSafe((String)string2);
            if (clazz == null) {
                throw new IllegalStateException("Failed to determine class from '" + string2 + "'");
            }
            Object object = MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_VALUE), (Class)clazz);
            iMutableSettings.restoreValue(string, object);
        });
        return iMutableSettings;
    }
}

