/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.settings.IMutableSettings;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.exchange.xml.SettingsMicroDocumentConverter;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public class SettingsPersistenceXML
implements ISettingsPersistence {
    public static final boolean DEFAULT_MARSHAL_TYPES = true;
    private final ISettingsFactory m_aSettingsFactory;
    private final IXMLWriterSettings m_aXWS;

    public SettingsPersistenceXML() {
        this(ISettingsFactory.newInstance());
    }

    public SettingsPersistenceXML(@Nonnull ISettingsFactory iSettingsFactory) {
        this(iSettingsFactory, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public SettingsPersistenceXML(@Nonnull ISettingsFactory iSettingsFactory, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aSettingsFactory = (ISettingsFactory)ValueEnforcer.notNull((Object)iSettingsFactory, (String)"SettingsFactory");
        this.m_aXWS = iXMLWriterSettings;
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aXWS.getCharsetObj();
    }

    @Nonnull
    public ISettingsFactory getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    @Nonnull
    public IXMLWriterSettings getXMLWriterSettings() {
        return this.m_aXWS;
    }

    @Override
    @Nonnull
    public IMutableSettings readSettings(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Passed XML document is illegal");
        }
        SettingsMicroDocumentConverter settingsMicroDocumentConverter = new SettingsMicroDocumentConverter(this.m_aSettingsFactory);
        return settingsMicroDocumentConverter.convertToNative(iMicroDocument.getDocumentElement());
    }

    @Nullable
    @OverrideOnDemand
    protected String getWriteNamespaceURI() {
        return null;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getWriteElementName() {
        return "settings";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull((Object)iSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            ValueEnforcer.notNull((Object)iSettings, (String)"Settings");
            SettingsMicroDocumentConverter settingsMicroDocumentConverter = new SettingsMicroDocumentConverter(this.m_aSettingsFactory);
            MicroDocument microDocument = new MicroDocument();
            microDocument.appendChild((IMicroNode)settingsMicroDocumentConverter.convertToMicroElement(iSettings, this.getWriteNamespaceURI(), this.getWriteElementName()));
            ESuccess eSuccess = MicroWriter.writeToStream((IMicroNode)microDocument, (OutputStream)outputStream, (IXMLWriterSettings)this.m_aXWS);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

