/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.settings.IMutableSettings;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.SettingsWithDefault;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface ISettingsFactory
extends Function<String, IMutableSettings> {
    @Override
    @Nonnull
    public IMutableSettings apply(@Nonnull @Nonempty String var1);

    @Nonnull
    public static ISettingsFactory newInstance() {
        return string -> new Settings(string);
    }

    @Nonnull
    public static ISettingsFactory newInstance(@Nonnull ISettings iSettings) {
        ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
        return string -> new SettingsWithDefault(string, iSettings);
    }
}

