/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.tinymce4;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.annotations.Nonempty;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;

public enum ETinyMCE4JSPathProvider implements IJSPathProvider
{
  TINYMCE_4 ("tinymce-dev/tinymce.jquery.js", "tinymce-min/tinymce.min.js");

  private final ConstantJSPathProvider m_aPP;

  private ETinyMCE4JSPathProvider (@Nonnull @Nonempty final String sRegularPath,
                                   @Nonnull @Nonempty final String sMinPath)
  {
    m_aPP = new ConstantJSPathProvider (sRegularPath, sMinPath);
  }

  @Nonnull
  @Nonempty
  public String getJSItemPath (final boolean bRegular)
  {
    return m_aPP.getJSItemPath (bRegular);
  }

  @Nullable
  public String getConditionalComment ()
  {
    return m_aPP.getConditionalComment ();
  }

  public boolean canBeBundled ()
  {
    return m_aPP.canBeBundled ();
  }
}
