/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.tinymce4.type;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.string.StringHelper;

/**
 * All TinyMCE4 menu controls.<br>
 * Partly generated by MainCreateTinyMCEMenuControls
 *
 * @author Philip Helger
 */
public enum ETinyMCE4MenuControl
{
  NEWDOCUMENT ("newdocument", null),
  UNDO ("undo", null),
  REDO ("redo", null),
  VISUALAID ("visualaid", null),
  CUT ("cut", null),
  COPY ("copy", null),
  PASTE ("paste", null),
  SELECTALL ("selectall", null),
  BOLD ("bold", null),
  ITALIC ("italic", null),
  UNDERLINE ("underline", null),
  STRIKETHROUGH ("strikethrough", null),
  SUBSCRIPT ("subscript", null),
  SUPERSCRIPT ("superscript", null),
  REMOVEFORMAT ("removeformat", null),
  FORMATS ("formats", null),
  LINK ("link", ETinyMCE4Plugin.LINK),
  IMAGE ("image", ETinyMCE4Plugin.IMAGE),
  CHARMAP ("charmap", ETinyMCE4Plugin.CHARMAP),
  PASTETEXT ("pastetext", ETinyMCE4Plugin.PASTE),
  PRINT ("print", ETinyMCE4Plugin.PRINT),
  PREVIEW ("preview", ETinyMCE4Plugin.PREVIEW),
  HR ("hr", ETinyMCE4Plugin.HR),
  ANCHOR ("anchor", ETinyMCE4Plugin.ANCHOR),
  PAGEBREAK ("pagebreak", ETinyMCE4Plugin.PAGEBREAK),
  SPELLCHECKER ("spellchecker", ETinyMCE4Plugin.SPELLCHECKER),
  SEARCHREPLACE ("searchreplace", ETinyMCE4Plugin.SEARCHREPLACE),
  VISUALBLOCKS ("visualblocks", ETinyMCE4Plugin.VISUALBLOCKS),
  VISUALCHARS ("visualchars", ETinyMCE4Plugin.VISUALCHARS),
  CODE ("code", ETinyMCE4Plugin.CODE),
  FULLSCREEN ("fullscreen", ETinyMCE4Plugin.FULLSCREEN),
  INSERTDATETIME ("insertdatetime", ETinyMCE4Plugin.INSERTDATETIME),
  MEDIA ("media", ETinyMCE4Plugin.MEDIA),
  NONBREAKING ("nonbreaking", ETinyMCE4Plugin.NONBREAKING),
  INSERTTABLE ("inserttable", ETinyMCE4Plugin.TABLE),
  TABLEPROPS ("tableprops", ETinyMCE4Plugin.TABLE),
  DELETETABLE ("deletetable", ETinyMCE4Plugin.TABLE),
  CELL ("cell", ETinyMCE4Plugin.TABLE),
  ROW ("row", ETinyMCE4Plugin.TABLE),
  COLUMN ("column", ETinyMCE4Plugin.TABLE);

  private final String m_sValue;
  private final ETinyMCE4Plugin m_eRequiredPlugin;

  private ETinyMCE4MenuControl (@Nonnull @Nonempty final String sValue, @Nullable final ETinyMCE4Plugin eRequiredPlugin)
  {
    m_sValue = sValue;
    m_eRequiredPlugin = eRequiredPlugin;
  }

  @Nonnull
  @Nonempty
  public String getValue ()
  {
    return m_sValue;
  }

  public boolean isSpecialPluginRequired ()
  {
    return m_eRequiredPlugin != null;
  }

  @Nullable
  public ETinyMCE4Plugin getRequiredPlugin ()
  {
    return m_eRequiredPlugin;
  }

  @Nullable
  public static ETinyMCE4MenuControl getFromValueOrNull (@Nullable final String sValue)
  {
    return getFromValueOrDefault (sValue, null);
  }

  @Nullable
  public static ETinyMCE4MenuControl getFromValueOrDefault (@Nullable final String sValue,
                                                            @Nullable final ETinyMCE4MenuControl eDefault)
  {
    if (StringHelper.hasText (sValue))
      for (final ETinyMCE4MenuControl e : values ())
        if (sValue.equals (e.m_sValue))
          return e;
    return eDefault;
  }
}
