/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.tinymce4.type;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;

/**
 * All TinyMCE4 supported themes.<br>
 * Partly generated by MainCreateTinyMCEThemeEnum
 *
 * @author Philip Helger
 */
public enum ETinyMCE4Theme
{
  MODERN ("modern", new TinyMCE4ToolbarControlList (ETinyMCE4ToolbarControl.UNDO,
                                                    ETinyMCE4ToolbarControl.REDO,
                                                    null,
                                                    ETinyMCE4ToolbarControl.STYLESELECT,
                                                    null,
                                                    ETinyMCE4ToolbarControl.BOLD,
                                                    ETinyMCE4ToolbarControl.ITALIC,
                                                    null,
                                                    ETinyMCE4ToolbarControl.ALIGNLEFT,
                                                    ETinyMCE4ToolbarControl.ALIGNCENTER,
                                                    ETinyMCE4ToolbarControl.ALIGNRIGHT,
                                                    ETinyMCE4ToolbarControl.ALIGNJUSTIFY,
                                                    null,
                                                    ETinyMCE4ToolbarControl.BULLIST,
                                                    ETinyMCE4ToolbarControl.NUMLIST,
                                                    ETinyMCE4ToolbarControl.OUTDENT,
                                                    ETinyMCE4ToolbarControl.INDENT,
                                                    null,
                                                    ETinyMCE4ToolbarControl.LINK,
                                                    ETinyMCE4ToolbarControl.IMAGE));

  /** The default theme */
  public static final ETinyMCE4Theme DEFAULT = MODERN;

  private final String m_sValue;
  private final TinyMCE4ToolbarControlList m_aDefaultToolbar;

  private ETinyMCE4Theme (@Nonnull @Nonempty final String sValue,
                          @Nonnull final TinyMCE4ToolbarControlList aDefaultToolbar)
  {
    m_sValue = sValue;
    m_aDefaultToolbar = aDefaultToolbar;
  }

  @Nonnull
  @Nonempty
  public String getValue ()
  {
    return m_sValue;
  }

  /**
   * @return The default toolbar. See the respective theme.js file.
   */
  @Nonnull
  @ReturnsMutableCopy
  public TinyMCE4ToolbarControlList getDefaultToolbar ()
  {
    return m_aDefaultToolbar.getClone ();
  }

  @Nullable
  public static ETinyMCE4Theme getFromValueOrNull (@Nullable final String sValue)
  {
    return getFromValueOrDefault (sValue, null);
  }

  @Nullable
  public static ETinyMCE4Theme getFromValueOrDefault (@Nullable final String sValue,
                                                      @Nullable final ETinyMCE4Theme eDefault)
  {
    if (StringHelper.hasText (sValue))
      for (final ETinyMCE4Theme e : values ())
        if (sValue.equals (e.m_sValue))
          return e;
    return eDefault;
  }
}
