/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tinymce4;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNodeBuilder;
import com.helger.html.hc.api.EHCTextDirection;
import com.helger.html.hc.html.HCScript;
import com.helger.html.js.IJSCodeProvider;
import com.helger.html.js.builder.IJSExpression;
import com.helger.html.js.builder.JSAnonymousFunction;
import com.helger.html.js.builder.JSAssocArray;
import com.helger.html.js.builder.JSExpr;
import com.helger.html.js.builder.JSInvocation;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.json.IJson;
import com.helger.json.impl.JsonObject;
import com.helger.tinymce4.ETinyMCE4JSPathProvider;
import com.helger.tinymce4.JSTinyMCE4;
import com.helger.tinymce4.type.ETinyMCE4Language;
import com.helger.tinymce4.type.ETinyMCE4Plugin;
import com.helger.tinymce4.type.ETinyMCE4Resize;
import com.helger.tinymce4.type.ETinyMCE4Skin;
import com.helger.tinymce4.type.ETinyMCE4Theme;
import com.helger.tinymce4.type.TinyMCE4ExternalPlugin;
import com.helger.tinymce4.type.TinyMCE4MenubarItemList;
import com.helger.tinymce4.type.TinyMCE4ToolbarControlList;
import com.helger.webbasics.app.html.PerRequestJSIncludes;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCTinyMCE4
implements IHCNodeBuilder {
    public static final boolean DEFAULT_BROWSER_SPELLCHECK = false;
    public static final boolean DEFAULT_NOWRAP = false;
    public static final boolean DEFAULT_OBJECT_RESIZING = true;
    public static final String DEFAULT_SELECTOR = "textarea";
    public static final boolean DEFAULT_INLINE = false;
    public static final boolean DEFAULT_HIDDEN_INPUT = true;
    public static final boolean DEFAULT_CONVERT_FONTS_TO_SPANS = true;
    public static final boolean DEFAULT_TOOLBAR_DISABLED = false;
    public static final boolean DEFAULT_MENUBAR_DISABLED = false;
    public static final boolean DEFAULT_STATUSBAR = true;
    public static final boolean DEFAULT_PREVIEW_STYLES = true;
    private String m_sAutoFocus;
    private EHCTextDirection m_eDirectionality;
    private ETriState m_eBrowserSpellcheck = ETriState.UNDEFINED;
    private ETinyMCE4Language m_eLanguage;
    private ISimpleURL m_aLanguageURL;
    private ETriState m_eNoWrap = ETriState.UNDEFINED;
    private ETriState m_eObjectResizing = ETriState.UNDEFINED;
    private final Set<ETinyMCE4Plugin> m_aPlugins = new LinkedHashSet<ETinyMCE4Plugin>();
    private final Set<TinyMCE4ExternalPlugin> m_aExternalPlugins = new LinkedHashSet<TinyMCE4ExternalPlugin>();
    private String m_sSelector = "textarea";
    private ETinyMCE4Skin m_eSkin;
    private ISimpleURL m_aSkinURL;
    private ETinyMCE4Theme m_eTheme;
    private ISimpleURL m_aThemeURL;
    private ETriState m_eInline = ETriState.UNDEFINED;
    private ETriState m_eHiddenInput = ETriState.UNDEFINED;
    private ETriState m_eConvertFontsToSpans = ETriState.UNDEFINED;
    private TinyMCE4ToolbarControlList m_aToolbar;
    private boolean m_bToolbarDisabled = false;
    private TinyMCE4MenubarItemList m_aMenubar;
    private boolean m_bMenubarDisabled = false;
    private ETriState m_eStatusbar = ETriState.UNDEFINED;
    private ETinyMCE4Resize m_eResize;
    private int m_nWidth = -1;
    private int m_nHeight = -1;
    private ETriState m_ePreviewStyles = ETriState.UNDEFINED;
    private JSAnonymousFunction m_aFileBrowserCallback;
    private final Map<String, IJSExpression> m_aCustom = new LinkedHashMap<String, IJSExpression>();

    @Nullable
    public String getAutoFocus() {
        return this.m_sAutoFocus;
    }

    @Nonnull
    public HCTinyMCE4 setAutoFocus(@Nullable String string) {
        this.m_sAutoFocus = string;
        return this;
    }

    @Nullable
    public EHCTextDirection getDirectionality() {
        return this.m_eDirectionality;
    }

    @Nonnull
    public HCTinyMCE4 setDirectionality(@Nullable EHCTextDirection eHCTextDirection) {
        this.m_eDirectionality = eHCTextDirection;
        return this;
    }

    public boolean isBrowserSpellcheck() {
        return this.m_eBrowserSpellcheck.getAsBooleanValue(false);
    }

    @Nonnull
    public HCTinyMCE4 setBrowserSpellcheck(boolean bl) {
        this.m_eBrowserSpellcheck = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setBrowserSpellcheck(@Nullable Boolean bl) {
        this.m_eBrowserSpellcheck = ETriState.valueOf((Boolean)bl);
        return this;
    }

    @Nullable
    public ETinyMCE4Language getLanguage() {
        return this.m_eLanguage;
    }

    @Nonnull
    public HCTinyMCE4 setLanguage(@Nullable ETinyMCE4Language eTinyMCE4Language) {
        this.m_eLanguage = eTinyMCE4Language;
        return this;
    }

    @Nullable
    public ISimpleURL getLanguageURL() {
        return this.m_aLanguageURL;
    }

    @Nonnull
    public HCTinyMCE4 setLanguageURL(@Nullable ISimpleURL iSimpleURL) {
        this.m_aLanguageURL = iSimpleURL;
        return this;
    }

    public boolean isNoWrap() {
        return this.m_eNoWrap.getAsBooleanValue(false);
    }

    @Nonnull
    public HCTinyMCE4 setNoWrap(boolean bl) {
        this.m_eNoWrap = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setNoWrap(@Nullable Boolean bl) {
        this.m_eNoWrap = ETriState.valueOf((Boolean)bl);
        return this;
    }

    public boolean isObjectResizing() {
        return this.m_eObjectResizing.getAsBooleanValue(true);
    }

    @Nonnull
    public HCTinyMCE4 setObjectResizing(boolean bl) {
        this.m_eObjectResizing = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setObjectResizing(@Nullable Boolean bl) {
        this.m_eObjectResizing = ETriState.valueOf((Boolean)bl);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<ETinyMCE4Plugin> getAllPlugins() {
        return CollectionHelper.newOrderedSet(this.m_aPlugins);
    }

    @Nonnegative
    public int getPluginCount() {
        return this.m_aPlugins.size();
    }

    @Nonnull
    public HCTinyMCE4 addPlugin(@Nonnull ETinyMCE4Plugin eTinyMCE4Plugin) {
        if (eTinyMCE4Plugin == null) {
            throw new NullPointerException("plugin");
        }
        this.m_aPlugins.add(eTinyMCE4Plugin);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addPlugins(ETinyMCE4Plugin ... eTinyMCE4PluginArray) {
        if (eTinyMCE4PluginArray != null) {
            for (ETinyMCE4Plugin eTinyMCE4Plugin : eTinyMCE4PluginArray) {
                this.addPlugin(eTinyMCE4Plugin);
            }
        }
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addPlugins(@Nullable Iterable<ETinyMCE4Plugin> iterable) {
        if (iterable != null) {
            for (ETinyMCE4Plugin eTinyMCE4Plugin : iterable) {
                this.addPlugin(eTinyMCE4Plugin);
            }
        }
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addAllPlugins() {
        return this.addPlugins(ETinyMCE4Plugin.values());
    }

    @Nonnull
    public EChange removePlugin(@Nullable ETinyMCE4Plugin eTinyMCE4Plugin) {
        return EChange.valueOf((eTinyMCE4Plugin != null && this.m_aPlugins.remove((Object)eTinyMCE4Plugin) ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removePlugins(ETinyMCE4Plugin ... eTinyMCE4PluginArray) {
        EChange eChange = EChange.UNCHANGED;
        if (eTinyMCE4PluginArray != null) {
            for (ETinyMCE4Plugin eTinyMCE4Plugin : eTinyMCE4PluginArray) {
                eChange = eChange.or((IChangeIndicator)this.removePlugin(eTinyMCE4Plugin));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange removePlugins(@Nullable Iterable<ETinyMCE4Plugin> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (ETinyMCE4Plugin eTinyMCE4Plugin : iterable) {
                eChange = eChange.or((IChangeIndicator)this.removePlugin(eTinyMCE4Plugin));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<TinyMCE4ExternalPlugin> getAllExternalPlugins() {
        return CollectionHelper.newOrderedSet(this.m_aExternalPlugins);
    }

    @Nonnegative
    public int getExternalPluginCount() {
        return this.m_aExternalPlugins.size();
    }

    @Nonnull
    public HCTinyMCE4 addExternalPlugin(@Nonnull TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin) {
        if (tinyMCE4ExternalPlugin == null) {
            throw new NullPointerException("plugin");
        }
        this.m_aExternalPlugins.add(tinyMCE4ExternalPlugin);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addExternalPlugins(TinyMCE4ExternalPlugin ... tinyMCE4ExternalPluginArray) {
        if (tinyMCE4ExternalPluginArray != null) {
            for (TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin : tinyMCE4ExternalPluginArray) {
                this.addExternalPlugin(tinyMCE4ExternalPlugin);
            }
        }
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addExternalPlugins(@Nullable Iterable<? extends TinyMCE4ExternalPlugin> iterable) {
        if (iterable != null) {
            for (TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin : iterable) {
                this.addExternalPlugin(tinyMCE4ExternalPlugin);
            }
        }
        return this;
    }

    @Nonnull
    public EChange removeExternalPlugin(@Nullable TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin) {
        return EChange.valueOf((tinyMCE4ExternalPlugin != null && this.m_aExternalPlugins.remove(tinyMCE4ExternalPlugin) ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removeExternalPlugins(TinyMCE4ExternalPlugin ... tinyMCE4ExternalPluginArray) {
        EChange eChange = EChange.UNCHANGED;
        if (tinyMCE4ExternalPluginArray != null) {
            for (TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin : tinyMCE4ExternalPluginArray) {
                eChange = eChange.or((IChangeIndicator)this.removeExternalPlugin(tinyMCE4ExternalPlugin));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange removeExternalPlugins(@Nullable Iterable<? extends TinyMCE4ExternalPlugin> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin : iterable) {
                eChange = eChange.or((IChangeIndicator)this.removeExternalPlugin(tinyMCE4ExternalPlugin));
            }
        }
        return eChange;
    }

    @Nonnull
    @Nonempty
    public String getSelector() {
        return this.m_sSelector;
    }

    @Nonnull
    public HCTinyMCE4 setSelector(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("selector");
        }
        this.m_sSelector = string;
        return this;
    }

    @Nullable
    public ETinyMCE4Skin getSkin() {
        return this.m_eSkin;
    }

    @Nonnull
    public HCTinyMCE4 setSkin(@Nullable ETinyMCE4Skin eTinyMCE4Skin) {
        this.m_eSkin = eTinyMCE4Skin;
        return this;
    }

    @Nullable
    public ISimpleURL getSkinURL() {
        return this.m_aSkinURL;
    }

    @Nonnull
    public HCTinyMCE4 setSkinURL(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSkinURL = iSimpleURL;
        return this;
    }

    @Nullable
    public ETinyMCE4Theme getTheme() {
        return this.m_eTheme;
    }

    @Nonnull
    public HCTinyMCE4 setTheme(@Nullable ETinyMCE4Theme eTinyMCE4Theme) {
        this.m_eTheme = eTinyMCE4Theme;
        return this;
    }

    @Nullable
    public ISimpleURL getThemeURL() {
        return this.m_aThemeURL;
    }

    @Nonnull
    public HCTinyMCE4 setThemeURL(@Nullable ISimpleURL iSimpleURL) {
        this.m_aThemeURL = iSimpleURL;
        return this;
    }

    public boolean isInline() {
        return this.m_eInline.getAsBooleanValue(false);
    }

    @Nonnull
    public HCTinyMCE4 setInline(boolean bl) {
        this.m_eInline = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setInline(@Nullable Boolean bl) {
        this.m_eInline = ETriState.valueOf((Boolean)bl);
        return this;
    }

    public boolean isHiddenInput() {
        return this.m_eHiddenInput.getAsBooleanValue(true);
    }

    @Nonnull
    public HCTinyMCE4 setHiddenInput(boolean bl) {
        this.m_eHiddenInput = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setHiddenInput(@Nullable Boolean bl) {
        this.m_eHiddenInput = ETriState.valueOf((Boolean)bl);
        return this;
    }

    public boolean isConvertFontsToSpans() {
        return this.m_eConvertFontsToSpans.getAsBooleanValue(true);
    }

    @Nonnull
    public HCTinyMCE4 setConvertFontsToSpans(boolean bl) {
        this.m_eConvertFontsToSpans = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setConvertFontsToSpans(@Nullable Boolean bl) {
        this.m_eConvertFontsToSpans = ETriState.valueOf((Boolean)bl);
        return this;
    }

    @Nullable
    @ReturnsMutableObject(reason="Design")
    public TinyMCE4ToolbarControlList getToolbar() {
        return this.m_aToolbar;
    }

    @Nonnull
    public HCTinyMCE4 setToolbar(@Nullable TinyMCE4ToolbarControlList tinyMCE4ToolbarControlList) {
        this.m_aToolbar = tinyMCE4ToolbarControlList == null ? null : tinyMCE4ToolbarControlList.getClone();
        return this;
    }

    public boolean isToolbarDisabled() {
        return this.m_bToolbarDisabled;
    }

    @Nonnull
    public HCTinyMCE4 setToolbarDisabled(boolean bl) {
        this.m_bToolbarDisabled = bl;
        return this;
    }

    @Nullable
    @ReturnsMutableObject(reason="Design")
    public TinyMCE4MenubarItemList getMenubar() {
        return this.m_aMenubar;
    }

    @Nonnull
    public HCTinyMCE4 setMenubar(@Nullable TinyMCE4MenubarItemList tinyMCE4MenubarItemList) {
        this.m_aMenubar = tinyMCE4MenubarItemList == null ? null : tinyMCE4MenubarItemList.getClone();
        return this;
    }

    public boolean isMenubarDisabled() {
        return this.m_bMenubarDisabled;
    }

    @Nonnull
    public HCTinyMCE4 setMenubarDisabled(boolean bl) {
        this.m_bMenubarDisabled = bl;
        return this;
    }

    public boolean isStatusbar() {
        return this.m_eStatusbar.getAsBooleanValue(true);
    }

    @Nonnull
    public HCTinyMCE4 setStatusbar(boolean bl) {
        this.m_eStatusbar = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setStatusbar(@Nullable Boolean bl) {
        this.m_eStatusbar = ETriState.valueOf((Boolean)bl);
        return this;
    }

    @Nullable
    public ETinyMCE4Resize getResize() {
        return this.m_eResize;
    }

    @Nonnull
    public HCTinyMCE4 setResize(@Nullable ETinyMCE4Resize eTinyMCE4Resize) {
        this.m_eResize = eTinyMCE4Resize;
        return this;
    }

    public int getWidth() {
        return this.m_nWidth;
    }

    @Nonnull
    public HCTinyMCE4 setWidth(int n) {
        this.m_nWidth = n;
        return this;
    }

    public int getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    public HCTinyMCE4 setHeight(int n) {
        this.m_nHeight = n;
        return this;
    }

    public boolean isPreviewStyles() {
        return this.m_ePreviewStyles.getAsBooleanValue(true);
    }

    @Nonnull
    public HCTinyMCE4 setPreviewStyles(boolean bl) {
        this.m_ePreviewStyles = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public HCTinyMCE4 setPreviewStyles(@Nullable Boolean bl) {
        this.m_ePreviewStyles = ETriState.valueOf((Boolean)bl);
        return this;
    }

    @Nullable
    public JSAnonymousFunction getFileBrowserCallback() {
        return this.m_aFileBrowserCallback;
    }

    @Nonnull
    public HCTinyMCE4 setFileBrowserCallback(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aFileBrowserCallback = jSAnonymousFunction;
        return this;
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, boolean bl) {
        return this.addCustomOption(string, (IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, int n) {
        return this.addCustomOption(string, (IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, double d) {
        return this.addCustomOption(string, (IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, @Nonnull BigDecimal bigDecimal) {
        return this.addCustomOption(string, (IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return this.addCustomOption(string, (IJSExpression)JSExpr.lit((String)string2));
    }

    @Nonnull
    public HCTinyMCE4 addCustomOption(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("name");
        }
        if (iJSExpression == null) {
            throw new NullPointerException("value");
        }
        this.m_aCustom.put(string, iJSExpression);
        return this;
    }

    @Nullable
    public IJSExpression removeCustomOption(@Nullable String string) {
        return this.m_aCustom.remove(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<String, IJSExpression> getAllCustomOptions() {
        return CollectionHelper.newOrderedMap(this.m_aCustom);
    }

    public boolean containsCustomOption(@Nullable String string) {
        return this.m_aCustom.containsKey(string);
    }

    @Nullable
    public IJSExpression getCustomOptionValue(@Nullable String string) {
        return this.m_aCustom.get(string);
    }

    @Nonnegative
    public int getCustomOptionCount() {
        return this.m_aCustom.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getJSInitOptions() {
        Object object;
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (StringHelper.hasText((String)this.m_sAutoFocus)) {
            jSAssocArray.add("auto_focus", this.m_sAutoFocus);
        }
        if (this.m_eBrowserSpellcheck.isDefined()) {
            jSAssocArray.add("browser_spellcheck", this.isBrowserSpellcheck());
        }
        if (this.m_eDirectionality != null) {
            jSAssocArray.add("directionality", this.m_eDirectionality.getAttrValue());
        }
        if (this.m_eLanguage != null) {
            jSAssocArray.add("language", this.m_eLanguage.getValue());
        }
        if (this.m_aLanguageURL != null) {
            jSAssocArray.add("language_url", this.m_aLanguageURL.getAsString());
        }
        if (this.m_eNoWrap.isDefined()) {
            jSAssocArray.add("nowrap", this.isNoWrap());
        }
        if (this.m_eObjectResizing.isDefined()) {
            jSAssocArray.add("object_resizing", this.isObjectResizing());
        }
        if (!this.m_aPlugins.isEmpty()) {
            object = new StringBuilder();
            for (ETinyMCE4Plugin eTinyMCE4Plugin : this.m_aPlugins) {
                if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).append(' ');
                }
                ((StringBuilder)object).append(eTinyMCE4Plugin.getValue());
            }
            jSAssocArray.add("plugins", ((StringBuilder)object).toString());
        }
        if (!this.m_aExternalPlugins.isEmpty()) {
            object = new JsonObject();
            for (TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin : this.m_aExternalPlugins) {
                object.add(tinyMCE4ExternalPlugin.getPluginName(), (Object)tinyMCE4ExternalPlugin.getPluginURL().getAsString());
            }
            jSAssocArray.add("external_plugins", (IJson)object);
        }
        jSAssocArray.add("selector", this.m_sSelector);
        if (this.m_eSkin != null) {
            jSAssocArray.add("skin", this.m_eSkin.getValue());
        }
        if (this.m_aSkinURL != null) {
            jSAssocArray.add("skin_url", this.m_aSkinURL.getAsString());
        }
        if (this.m_eTheme != null) {
            jSAssocArray.add("theme", this.m_eTheme.getValue());
        }
        if (this.m_aThemeURL != null) {
            jSAssocArray.add("theme_url", this.m_aThemeURL.getAsString());
        }
        if (this.m_eInline.isDefined()) {
            jSAssocArray.add("inline", this.isInline());
        }
        if (this.m_eHiddenInput.isDefined()) {
            jSAssocArray.add("hidden_input", this.isHiddenInput());
        }
        if (this.m_eConvertFontsToSpans.isDefined()) {
            jSAssocArray.add("convert_fonts_to_spans", this.isConvertFontsToSpans());
        }
        if (this.m_bToolbarDisabled) {
            jSAssocArray.add("toolbar", (IJSExpression)JSExpr.FALSE);
        } else if (this.m_aToolbar != null) {
            jSAssocArray.add("toolbar", this.m_aToolbar.getAsOptionString());
        }
        if (this.m_bMenubarDisabled) {
            jSAssocArray.add("menubar", (IJSExpression)JSExpr.FALSE);
        } else if (this.m_aMenubar != null) {
            jSAssocArray.add("menubar", this.m_aMenubar.getAsOptionString());
        }
        if (this.m_eStatusbar.isDefined()) {
            jSAssocArray.add("statusbar", this.isStatusbar());
        }
        if (this.m_eResize != null) {
            jSAssocArray.add("resize", this.m_eResize.getValue());
        }
        if (this.m_nWidth >= 0) {
            jSAssocArray.add("width", this.m_nWidth);
        }
        if (this.m_nHeight >= 0) {
            jSAssocArray.add("height", this.m_nHeight);
        }
        if (this.m_ePreviewStyles.isDefined()) {
            jSAssocArray.add("preview_styles", this.isPreviewStyles());
        }
        if (this.m_aFileBrowserCallback != null) {
            jSAssocArray.add("file_browser_callback", (IJSExpression)this.m_aFileBrowserCallback);
        }
        for (Map.Entry entry : this.m_aCustom.entrySet()) {
            jSAssocArray.add((String)entry.getKey(), (IJSExpression)entry.getValue());
        }
        return jSAssocArray;
    }

    @Nonnull
    public JSInvocation getJSInvocation() {
        return JSTinyMCE4.init(this.getJSInitOptions());
    }

    @Nonnull
    public HCScript build() {
        HCTinyMCE4.registerExternalResources();
        return new HCScript((IJSCodeProvider)this.getJSInvocation());
    }

    public static void registerExternalResources() {
        PerRequestJSIncludes.registerJSIncludeForThisRequest((IJSPathProvider)ETinyMCE4JSPathProvider.TINYMCE_4);
    }
}

