/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tinymce4.type;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ETinyMCE4Language {
    AR("ar"),
    AR_SA("ar_SA"),
    AZ("az"),
    BE("be"),
    BG_BG("bg_BG"),
    BN_BD("bn_BD"),
    BS("bs"),
    CA("ca"),
    CS("cs"),
    CY("cy"),
    DA("da"),
    DE("de"),
    DE_AT("de_AT"),
    DV("dv"),
    EL("el"),
    EN_CA("en_CA"),
    EN_GB("en_GB"),
    ES("es"),
    ES_MX("es_MX"),
    ET("et"),
    EU("eu"),
    FA("fa"),
    FA_IR("fa_IR"),
    FI("fi"),
    FO("fo"),
    FR_FR("fr_FR"),
    GD("gd"),
    GL("gl"),
    HE_IL("he_IL"),
    HI_IN("hi_IN"),
    HR("hr"),
    HU_HU("hu_HU"),
    HY("hy"),
    ID("id"),
    IS_IS("is_IS"),
    IT("it"),
    JA("ja"),
    KA_GE("ka_GE"),
    KK("kk"),
    KM_KH("km_KH"),
    KO_KR("ko_KR"),
    KU("ku"),
    KU_IQ("ku_IQ"),
    LB("lb"),
    LT("lt"),
    LV("lv"),
    ML("ml"),
    ML_IN("ml_IN"),
    MN_MN("mn_MN"),
    NB_NO("nb_NO"),
    NL("nl"),
    PL("pl"),
    PT_BR("pt_BR"),
    PT_PT("pt_PT"),
    RO("ro"),
    RU("ru"),
    SI_LK("si_LK"),
    SK("sk"),
    SL_SI("sl_SI"),
    SR("sr"),
    SV_SE("sv_SE"),
    TA("ta"),
    TA_IN("ta_IN"),
    TG("tg"),
    TH_TH("th_TH"),
    TR_TR("tr_TR"),
    TT("tt"),
    UG("ug"),
    UK("uk"),
    UK_UA("uk_UA"),
    VI("vi"),
    VI_VN("vi_VN"),
    ZH_CN("zh_CN"),
    ZH_TW("zh_TW");

    private final String m_sValue;

    private ETinyMCE4Language(String string2) {
        this.m_sValue = string2;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Nullable
    public static ETinyMCE4Language getFromValueOrNull(@Nullable String string) {
        return ETinyMCE4Language.getFromValueOrDefault(string, null);
    }

    @Nullable
    public static ETinyMCE4Language getFromValueOrDefault(@Nullable String string, @Nullable ETinyMCE4Language eTinyMCE4Language) {
        if (StringHelper.hasText((String)string)) {
            for (ETinyMCE4Language eTinyMCE4Language2 : ETinyMCE4Language.values()) {
                if (!string.equals(eTinyMCE4Language2.m_sValue)) continue;
                return eTinyMCE4Language2;
            }
        }
        return eTinyMCE4Language;
    }

    @Nullable
    public static ETinyMCE4Language getFromLocaleOrNull(@Nullable Locale locale) {
        return ETinyMCE4Language.getFromLocaleOrDefault(locale, null);
    }

    @Nullable
    public static ETinyMCE4Language getFromLocaleOrDefault(@Nullable Locale locale, @Nullable ETinyMCE4Language eTinyMCE4Language) {
        if (locale != null && !locale.getLanguage().equals("en")) {
            int n;
            String string = locale.toString();
            Object object = ETinyMCE4Language.values();
            int n2 = ((ETinyMCE4Language[])object).length;
            for (n = 0; n < n2; ++n) {
                ETinyMCE4Language eTinyMCE4Language2 = object[n];
                if (!string.equals(eTinyMCE4Language2.m_sValue)) continue;
                return eTinyMCE4Language2;
            }
            if (StringHelper.hasText((String)locale.getCountry()) && (object = LocaleCache.getLocale((String)locale.getLanguage(), (String)locale.getCountry())) != null) {
                string = ((Locale)object).toString();
                ETinyMCE4Language[] eTinyMCE4LanguageArray = ETinyMCE4Language.values();
                n = eTinyMCE4LanguageArray.length;
                for (int i = 0; i < n; ++i) {
                    ETinyMCE4Language eTinyMCE4Language3 = eTinyMCE4LanguageArray[i];
                    if (!string.equals(eTinyMCE4Language3.m_sValue)) continue;
                    return eTinyMCE4Language3;
                }
            }
            if (StringHelper.hasText((String)locale.getLanguage())) {
                string = locale.getLanguage();
                for (ETinyMCE4Language eTinyMCE4Language4 : ETinyMCE4Language.values()) {
                    if (!string.equals(eTinyMCE4Language4.m_sValue)) continue;
                    return eTinyMCE4Language4;
                }
            }
        }
        return eTinyMCE4Language;
    }
}

