/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tinymce4.type;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TinyMCE4ExternalPlugin {
    private final String m_sPluginName;
    private final ISimpleURL m_aPluginURL;

    public TinyMCE4ExternalPlugin(@Nonnull @Nonempty String string, @Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PluginName");
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"PluginURL");
        this.m_sPluginName = string;
        this.m_aPluginURL = iSimpleURL;
    }

    @Nonnull
    @Nonempty
    public String getPluginName() {
        return this.m_sPluginName;
    }

    @Nonnull
    public ISimpleURL getPluginURL() {
        return this.m_aPluginURL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TinyMCE4ExternalPlugin tinyMCE4ExternalPlugin = (TinyMCE4ExternalPlugin)object;
        return this.m_sPluginName.equals(tinyMCE4ExternalPlugin.m_sPluginName) && this.m_aPluginURL.equals(tinyMCE4ExternalPlugin.m_aPluginURL);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPluginName).append((Object)this.m_aPluginURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pluginName", (Object)this.m_sPluginName).append("pluginURL", (Object)this.m_aPluginURL).toString();
    }
}

