/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tinymce4.type;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tinymce4.type.ETinyMCE4MenuItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class TinyMCE4MenubarItemList
implements ICloneable<TinyMCE4MenubarItemList> {
    private final List<ETinyMCE4MenuItem> m_aList;

    public TinyMCE4MenubarItemList() {
        this.m_aList = new ArrayList<ETinyMCE4MenuItem>();
    }

    public TinyMCE4MenubarItemList(ETinyMCE4MenuItem ... eTinyMCE4MenuItemArray) {
        ValueEnforcer.notNull((Object)eTinyMCE4MenuItemArray, (String)"List");
        this.m_aList = CollectionHelper.newList((Object[])eTinyMCE4MenuItemArray);
    }

    public TinyMCE4MenubarItemList(@Nonnull List<ETinyMCE4MenuItem> list) {
        ValueEnforcer.notNull(list, (String)"List");
        this.m_aList = CollectionHelper.newList(list);
    }

    public TinyMCE4MenubarItemList(@Nonnull TinyMCE4MenubarItemList tinyMCE4MenubarItemList) {
        ValueEnforcer.notNull((Object)tinyMCE4MenubarItemList, (String)"Other");
        this.m_aList = CollectionHelper.newList(tinyMCE4MenubarItemList.m_aList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ETinyMCE4MenuItem> getAllMenuItems() {
        return CollectionHelper.newList(this.m_aList);
    }

    @Nonnull
    public TinyMCE4MenubarItemList addMenuItem(@Nonnull ETinyMCE4MenuItem eTinyMCE4MenuItem) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4MenuItem), (String)"MenuItem");
        this.m_aList.add(eTinyMCE4MenuItem);
        return this;
    }

    @Nonnull
    public TinyMCE4MenubarItemList addMenuItem(@Nonnegative int n, @Nonnull ETinyMCE4MenuItem eTinyMCE4MenuItem) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4MenuItem), (String)"MenuItem");
        this.m_aList.add(n, eTinyMCE4MenuItem);
        return this;
    }

    @CheckForSigned
    public int getMenuItemIndex(@Nonnull ETinyMCE4MenuItem eTinyMCE4MenuItem) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4MenuItem), (String)"MenuItem");
        return this.m_aList.indexOf((Object)eTinyMCE4MenuItem);
    }

    @Nonnull
    public EChange removeMenuItem(@Nonnull ETinyMCE4MenuItem eTinyMCE4MenuItem) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4MenuItem), (String)"MenuItem");
        return EChange.valueOf((boolean)this.m_aList.remove((Object)eTinyMCE4MenuItem));
    }

    @Nonnull
    public EChange removeAtIndex(@Nonnegative int n) {
        return CollectionHelper.removeElementAtIndex(this.m_aList, (int)n);
    }

    @Nonnull
    public EChange removeAll() {
        if (this.m_aList.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aList.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    public String getAsOptionString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ETinyMCE4MenuItem eTinyMCE4MenuItem : this.m_aList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(eTinyMCE4MenuItem.getValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public TinyMCE4MenubarItemList getClone() {
        return new TinyMCE4MenubarItemList(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).toString();
    }
}

