/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tinymce4.type;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tinymce4.type.ETinyMCE4ToolbarControl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class TinyMCE4ToolbarControlList
implements ICloneable<TinyMCE4ToolbarControlList> {
    private final List<ETinyMCE4ToolbarControl> m_aList;

    public TinyMCE4ToolbarControlList() {
        this.m_aList = new ArrayList<ETinyMCE4ToolbarControl>();
    }

    public TinyMCE4ToolbarControlList(ETinyMCE4ToolbarControl ... eTinyMCE4ToolbarControlArray) {
        ValueEnforcer.notNull((Object)eTinyMCE4ToolbarControlArray, (String)"List");
        this.m_aList = CollectionHelper.newList((Object[])eTinyMCE4ToolbarControlArray);
    }

    public TinyMCE4ToolbarControlList(@Nonnull List<ETinyMCE4ToolbarControl> list) {
        ValueEnforcer.notNull(list, (String)"List");
        this.m_aList = CollectionHelper.newList(list);
    }

    public TinyMCE4ToolbarControlList(@Nonnull TinyMCE4ToolbarControlList tinyMCE4ToolbarControlList) {
        ValueEnforcer.notNull((Object)tinyMCE4ToolbarControlList, (String)"Other");
        this.m_aList = CollectionHelper.newList(tinyMCE4ToolbarControlList.m_aList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ETinyMCE4ToolbarControl> getAllControls() {
        return CollectionHelper.newList(this.m_aList);
    }

    @Nonnull
    public TinyMCE4ToolbarControlList addSeparator() {
        this.m_aList.add(null);
        return this;
    }

    @Nonnull
    public TinyMCE4ToolbarControlList addSeparator(@Nonnegative int n) {
        this.m_aList.add(n, null);
        return this;
    }

    @Nonnull
    public TinyMCE4ToolbarControlList addControl(@Nonnull ETinyMCE4ToolbarControl eTinyMCE4ToolbarControl) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4ToolbarControl), (String)"Control");
        this.m_aList.add(eTinyMCE4ToolbarControl);
        return this;
    }

    @Nonnull
    public TinyMCE4ToolbarControlList addControl(@Nonnegative int n, @Nonnull ETinyMCE4ToolbarControl eTinyMCE4ToolbarControl) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4ToolbarControl), (String)"Control");
        this.m_aList.add(n, eTinyMCE4ToolbarControl);
        return this;
    }

    @CheckForSigned
    public int getControlIndex(@Nonnull ETinyMCE4ToolbarControl eTinyMCE4ToolbarControl) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4ToolbarControl), (String)"Control");
        return this.m_aList.indexOf((Object)eTinyMCE4ToolbarControl);
    }

    @Nonnull
    public EChange removeControl(@Nonnull ETinyMCE4ToolbarControl eTinyMCE4ToolbarControl) {
        ValueEnforcer.notNull((Object)((Object)eTinyMCE4ToolbarControl), (String)"Control");
        return EChange.valueOf((boolean)this.m_aList.remove((Object)eTinyMCE4ToolbarControl));
    }

    @Nonnull
    public EChange removeAtIndex(@Nonnegative int n) {
        return CollectionHelper.removeElementAtIndex(this.m_aList, (int)n);
    }

    @Nonnull
    public EChange removeAll() {
        if (this.m_aList.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aList.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    public String getAsOptionString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ETinyMCE4ToolbarControl eTinyMCE4ToolbarControl : this.m_aList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (eTinyMCE4ToolbarControl == null) {
                stringBuilder.append('|');
                continue;
            }
            stringBuilder.append(eTinyMCE4ToolbarControl.getValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public TinyMCE4ToolbarControlList getClone() {
        return new TinyMCE4ToolbarControlList(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).toString();
    }
}

