/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.annotations.CodingStyleguideUnaware;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.CGStringHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.schema.XMLSchemaCache;
import com.helger.commons.xml.schema.XMLSchemaValidationHelper;
import com.helger.ubl.IUBLDocumentType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.billoflading_2.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.catalogue_2.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_2.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_2.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_2.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_2.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_2.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_2.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_2.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_2.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_2.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.order_2.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_2.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_2.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_2.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_2.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_2.PackingListType;
import oasis.names.specification.ubl.schema.xsd.quotation_2.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_2.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_2.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_2.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_2.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_2.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_2.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_2.StatementType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_2.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.waybill_2.WaybillType;

public enum EUBL20DocumentType implements IUBLDocumentType
{
    APPLICATION_RESPONSE(ApplicationResponseType.class, "UBL-ApplicationResponse-2.0.xsd"),
    ATTACHED_DOCUMENT(AttachedDocumentType.class, "UBL-AttachedDocument-2.0.xsd"),
    BILL_OF_LADING(BillOfLadingType.class, "UBL-BillOfLading-2.0.xsd"),
    CATALOGUE(CatalogueType.class, "UBL-Catalogue-2.0.xsd"),
    CATALOGUE_DELETION(CatalogueDeletionType.class, "UBL-CatalogueDeletion-2.0.xsd"),
    CATALOGUE_ITEM_SPECIFICATION_UPDATE(CatalogueItemSpecificationUpdateType.class, "UBL-CatalogueItemSpecificationUpdate-2.0.xsd"),
    CATALOGUE_PRICING_UPDATE(CataloguePricingUpdateType.class, "UBL-CataloguePricingUpdate-2.0.xsd"),
    CATALOGUE_REQUEST(CatalogueRequestType.class, "UBL-CatalogueRequest-2.0.xsd"),
    CERTIFICATE_OF_ORIGIN(CertificateOfOriginType.class, "UBL-CertificateOfOrigin-2.0.xsd"),
    CREDIT_NOTE(CreditNoteType.class, "UBL-CreditNote-2.0.xsd"),
    DEBIT_NOTE(DebitNoteType.class, "UBL-DebitNote-2.0.xsd"),
    DESPATCH_ADVICE(DespatchAdviceType.class, "UBL-DespatchAdvice-2.0.xsd"),
    FORWARDING_INSTRUCTIONS(ForwardingInstructionsType.class, "UBL-ForwardingInstructions-2.0.xsd"),
    FREIGHT_INVOICE(FreightInvoiceType.class, "UBL-FreightInvoice-2.0.xsd"),
    INVOICE(InvoiceType.class, "UBL-Invoice-2.0.xsd"),
    ORDER(OrderType.class, "UBL-Order-2.0.xsd"),
    ORDER_CANCELLATION(OrderCancellationType.class, "UBL-OrderCancellation-2.0.xsd"),
    ORDER_CHANGE(OrderChangeType.class, "UBL-OrderChange-2.0.xsd"),
    ORDER_RESPONSE(OrderResponseType.class, "UBL-OrderResponse-2.0.xsd"),
    ORDER_RESPONSE_SIMPLE(OrderResponseSimpleType.class, "UBL-OrderResponseSimple-2.0.xsd"),
    PACKING_LIST(PackingListType.class, "UBL-PackingList-2.0.xsd"),
    QUOTATION(QuotationType.class, "UBL-Quotation-2.0.xsd"),
    RECEIPT_ADVICE(ReceiptAdviceType.class, "UBL-ReceiptAdvice-2.0.xsd"),
    REMINDER(ReminderType.class, "UBL-Reminder-2.0.xsd"),
    REMITTANCE_ADVICE(RemittanceAdviceType.class, "UBL-RemittanceAdvice-2.0.xsd"),
    REQUEST_FOR_QUOTATION(RequestForQuotationType.class, "UBL-RequestForQuotation-2.0.xsd"),
    SELF_BILLED_CREDIT_NOTE(SelfBilledCreditNoteType.class, "UBL-SelfBilledCreditNote-2.0.xsd"),
    SELF_BILLED_INVOICE(SelfBilledInvoiceType.class, "UBL-SelfBilledInvoice-2.0.xsd"),
    STATEMENT(StatementType.class, "UBL-Statement-2.0.xsd"),
    TRANSPORTATION_STATUS(TransportationStatusType.class, "UBL-TransportationStatus-2.0.xsd"),
    WAYBILL(WaybillType.class, "UBL-Waybill-2.0.xsd");

    private final Class<?> m_aClass;
    private final String m_sLocalName;
    private final String m_sNamespaceURI;
    private final QName m_aQName;
    private final String m_sXSDPath;
    @CodingStyleguideUnaware
    private Schema m_aSchema;

    private EUBL20DocumentType(Class<?> clazz, String string2) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (StringHelper.hasNoText((String)string2)) {
            throw new IllegalArgumentException("XSDPath");
        }
        XmlType xmlType = clazz.getAnnotation(XmlType.class);
        if (xmlType == null) {
            throw new IllegalArgumentException("The passed class does not have an @XMLType annotation!");
        }
        Package package_ = clazz.getPackage();
        XmlSchema xmlSchema = package_.getAnnotation(XmlSchema.class);
        if (xmlSchema == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no @XmlSchema annotation!");
        }
        String string3 = CGStringHelper.getClassLocalName(clazz);
        string3 = string3.substring(0, string3.length() - "Type".length());
        this.m_aClass = clazz;
        this.m_sLocalName = string3;
        this.m_sNamespaceURI = xmlSchema.namespace();
        if (StringHelper.hasNoText((String)this.m_sNamespaceURI)) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace in the @XmlSchema annotation!");
        }
        this.m_aQName = new QName(this.m_sNamespaceURI, string3);
        this.m_sXSDPath = "schemas/ubl20/maindoc/" + string2;
    }

    @Override
    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    public Package getPackage() {
        return this.m_aClass.getPackage();
    }

    @Override
    @Nonnull
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    @Nonnull
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    public QName getQName() {
        return this.m_aQName;
    }

    @Override
    @Nonnull
    public String getXSDPath() {
        return this.m_sXSDPath;
    }

    @Override
    @Nonnull
    public IReadableResource getXSDResource() {
        return new ClassPathResource(this.m_sXSDPath);
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Schema getSchema() {
        if (this.m_aSchema == null) {
            IReadableResource iReadableResource = this.getXSDResource();
            this.m_aSchema = XMLSchemaCache.getInstance().getSchema(iReadableResource);
            if (this.m_aSchema == null) {
                throw new IllegalStateException("Failed to create Schema from " + iReadableResource);
            }
        }
        return this.m_aSchema;
    }

    @Override
    @Nonnull
    public Validator getValidator() {
        return this.getSchema().newValidator();
    }

    @Override
    @Nonnull
    public IResourceErrorGroup validateXML(@Nonnull IReadableResource iReadableResource) {
        return XMLSchemaValidationHelper.validate((Schema)this.getSchema(), (IReadableResource)iReadableResource);
    }
}

