/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.annotations.ReturnsImmutableObject;
import com.helger.commons.collections.CollectionHelper;
import com.helger.ubl.EUBL20DocumentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL20DocumentTypes {
    private static final Map<String, EUBL20DocumentType> s_aNamespace2DocType = new HashMap<String, EUBL20DocumentType>();
    private static final Map<String, EUBL20DocumentType> s_aLocalName2DocType = new HashMap<String, EUBL20DocumentType>();
    private static final UBL20DocumentTypes s_aInstance;

    private UBL20DocumentTypes() {
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<String> getAllNamespaces() {
        return CollectionHelper.makeUnmodifiable(s_aNamespace2DocType.keySet());
    }

    @Nullable
    public static EUBL20DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return s_aNamespace2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<String> getAllLocalNames() {
        return CollectionHelper.makeUnmodifiable(s_aLocalName2DocType.keySet());
    }

    @Nullable
    public static EUBL20DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return s_aLocalName2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz != null) {
            for (EUBL20DocumentType eUBL20DocumentType : EUBL20DocumentType.values()) {
                if (!eUBL20DocumentType.getImplementationClass().equals(clazz)) continue;
                return eUBL20DocumentType.getSchema();
            }
        }
        return null;
    }

    static {
        for (EUBL20DocumentType eUBL20DocumentType : EUBL20DocumentType.values()) {
            String string = eUBL20DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey(string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put(string, eUBL20DocumentType);
            String string2 = eUBL20DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey(string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put(string2, eUBL20DocumentType);
        }
        s_aInstance = new UBL20DocumentTypes();
    }
}

