/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.io.IReadableResource;
import com.helger.commons.xml.transform.TransformSourceFactory;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.UBL20Marshaller;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.billoflading_2.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.catalogue_2.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_2.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_2.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_2.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_2.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_2.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_2.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_2.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_2.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_2.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.order_2.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_2.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_2.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_2.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_2.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_2.PackingListType;
import oasis.names.specification.ubl.schema.xsd.quotation_2.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_2.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_2.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_2.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_2.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_2.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_2.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_2.StatementType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_2.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.waybill_2.WaybillType;
import org.w3c.dom.Node;

@NotThreadSafe
public final class UBL20Reader
extends AbstractUBLDocumentMarshaller {
    private static final UBL20Reader s_aInstance = new UBL20Reader();

    private UBL20Reader() {
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Node node) {
        return UBL20Reader.readApplicationResponse(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, ApplicationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull File file) {
        return UBL20Reader.readApplicationResponse(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readApplicationResponse(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readApplicationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readApplicationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Source source) {
        return UBL20Reader.readApplicationResponse(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, ApplicationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Node node) {
        return UBL20Reader.readAttachedDocument(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, AttachedDocumentType.class, validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull File file) {
        return UBL20Reader.readAttachedDocument(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readAttachedDocument(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readAttachedDocument((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readAttachedDocument((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Source source) {
        return UBL20Reader.readAttachedDocument(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, AttachedDocumentType.class, validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Node node) {
        return UBL20Reader.readBillOfLading(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, BillOfLadingType.class, validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull File file) {
        return UBL20Reader.readBillOfLading(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readBillOfLading(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readBillOfLading((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readBillOfLading((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Source source) {
        return UBL20Reader.readBillOfLading(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, BillOfLadingType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Node node) {
        return UBL20Reader.readCatalogue(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CatalogueType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull File file) {
        return UBL20Reader.readCatalogue(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogue(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCatalogue((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogue((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Source source) {
        return UBL20Reader.readCatalogue(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CatalogueType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Node node) {
        return UBL20Reader.readCatalogueDeletion(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CatalogueDeletionType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull File file) {
        return UBL20Reader.readCatalogueDeletion(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueDeletion(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCatalogueDeletion((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueDeletion((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Source source) {
        return UBL20Reader.readCatalogueDeletion(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CatalogueDeletionType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Node node) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CatalogueItemSpecificationUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull File file) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Source source) {
        return UBL20Reader.readCatalogueItemSpecificationUpdate(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CatalogueItemSpecificationUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Node node) {
        return UBL20Reader.readCataloguePricingUpdate(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CataloguePricingUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull File file) {
        return UBL20Reader.readCataloguePricingUpdate(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCataloguePricingUpdate(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCataloguePricingUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCataloguePricingUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Source source) {
        return UBL20Reader.readCataloguePricingUpdate(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CataloguePricingUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Node node) {
        return UBL20Reader.readCatalogueRequest(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CatalogueRequestType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull File file) {
        return UBL20Reader.readCatalogueRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCatalogueRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCatalogueRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Source source) {
        return UBL20Reader.readCatalogueRequest(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CatalogueRequestType.class, validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Node node) {
        return UBL20Reader.readCertificateOfOrigin(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CertificateOfOriginType.class, validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull File file) {
        return UBL20Reader.readCertificateOfOrigin(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCertificateOfOrigin(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCertificateOfOrigin((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCertificateOfOrigin((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Source source) {
        return UBL20Reader.readCertificateOfOrigin(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CertificateOfOriginType.class, validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Node node) {
        return UBL20Reader.readCreditNote(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, CreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull File file) {
        return UBL20Reader.readCreditNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCreditNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Source source) {
        return UBL20Reader.readCreditNote(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, CreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Node node) {
        return UBL20Reader.readDebitNote(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, DebitNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull File file) {
        return UBL20Reader.readDebitNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readDebitNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readDebitNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readDebitNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Source source) {
        return UBL20Reader.readDebitNote(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, DebitNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Node node) {
        return UBL20Reader.readDespatchAdvice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, DespatchAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull File file) {
        return UBL20Reader.readDespatchAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readDespatchAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readDespatchAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readDespatchAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Source source) {
        return UBL20Reader.readDespatchAdvice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, DespatchAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Node node) {
        return UBL20Reader.readForwardingInstructions(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, ForwardingInstructionsType.class, validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull File file) {
        return UBL20Reader.readForwardingInstructions(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readForwardingInstructions(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readForwardingInstructions((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readForwardingInstructions((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Source source) {
        return UBL20Reader.readForwardingInstructions(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, ForwardingInstructionsType.class, validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Node node) {
        return UBL20Reader.readFreightInvoice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, FreightInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull File file) {
        return UBL20Reader.readFreightInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readFreightInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readFreightInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readFreightInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Source source) {
        return UBL20Reader.readFreightInvoice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, FreightInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Node node) {
        return UBL20Reader.readInvoice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, InvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull File file) {
        return UBL20Reader.readInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Source source) {
        return UBL20Reader.readInvoice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, InvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Node node) {
        return UBL20Reader.readOrder(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, OrderType.class, validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull File file) {
        return UBL20Reader.readOrder(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderType readOrder(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrder(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readOrder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderType readOrder(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Source source) {
        return UBL20Reader.readOrder(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, OrderType.class, validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Node node) {
        return UBL20Reader.readOrderCancellation(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, OrderCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull File file) {
        return UBL20Reader.readOrderCancellation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderCancellation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readOrderCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Source source) {
        return UBL20Reader.readOrderCancellation(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, OrderCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Node node) {
        return UBL20Reader.readOrderChange(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, OrderChangeType.class, validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull File file) {
        return UBL20Reader.readOrderChange(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderChange(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readOrderChange((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderChange((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Source source) {
        return UBL20Reader.readOrderChange(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, OrderChangeType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Node node) {
        return UBL20Reader.readOrderResponse(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, OrderResponseType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull File file) {
        return UBL20Reader.readOrderResponse(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderResponse(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readOrderResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Source source) {
        return UBL20Reader.readOrderResponse(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, OrderResponseType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Node node) {
        return UBL20Reader.readOrderResponseSimple(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, OrderResponseSimpleType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull File file) {
        return UBL20Reader.readOrderResponseSimple(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderResponseSimple(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readOrderResponseSimple((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readOrderResponseSimple((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Source source) {
        return UBL20Reader.readOrderResponseSimple(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, OrderResponseSimpleType.class, validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Node node) {
        return UBL20Reader.readPackingList(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, PackingListType.class, validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull File file) {
        return UBL20Reader.readPackingList(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readPackingList(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readPackingList((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readPackingList((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Source source) {
        return UBL20Reader.readPackingList(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, PackingListType.class, validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Node node) {
        return UBL20Reader.readQuotation(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, QuotationType.class, validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull File file) {
        return UBL20Reader.readQuotation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readQuotation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Source source) {
        return UBL20Reader.readQuotation(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, QuotationType.class, validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Node node) {
        return UBL20Reader.readReceiptAdvice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, ReceiptAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull File file) {
        return UBL20Reader.readReceiptAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readReceiptAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readReceiptAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readReceiptAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Source source) {
        return UBL20Reader.readReceiptAdvice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, ReceiptAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Node node) {
        return UBL20Reader.readReminder(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, ReminderType.class, validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull File file) {
        return UBL20Reader.readReminder(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readReminder(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readReminder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readReminder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Source source) {
        return UBL20Reader.readReminder(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, ReminderType.class, validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Node node) {
        return UBL20Reader.readRemittanceAdvice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, RemittanceAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull File file) {
        return UBL20Reader.readRemittanceAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readRemittanceAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readRemittanceAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readRemittanceAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Source source) {
        return UBL20Reader.readRemittanceAdvice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, RemittanceAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Node node) {
        return UBL20Reader.readRequestForQuotation(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, RequestForQuotationType.class, validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull File file) {
        return UBL20Reader.readRequestForQuotation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readRequestForQuotation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readRequestForQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readRequestForQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Source source) {
        return UBL20Reader.readRequestForQuotation(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, RequestForQuotationType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Node node) {
        return UBL20Reader.readSelfBilledCreditNote(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, SelfBilledCreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull File file) {
        return UBL20Reader.readSelfBilledCreditNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readSelfBilledCreditNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readSelfBilledCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readSelfBilledCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Source source) {
        return UBL20Reader.readSelfBilledCreditNote(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, SelfBilledCreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Node node) {
        return UBL20Reader.readSelfBilledInvoice(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, SelfBilledInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull File file) {
        return UBL20Reader.readSelfBilledInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readSelfBilledInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readSelfBilledInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readSelfBilledInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Source source) {
        return UBL20Reader.readSelfBilledInvoice(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, SelfBilledInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Node node) {
        return UBL20Reader.readStatement(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, StatementType.class, validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull File file) {
        return UBL20Reader.readStatement(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static StatementType readStatement(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readStatement(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static StatementType readStatement(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Source source) {
        return UBL20Reader.readStatement(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, StatementType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Node node) {
        return UBL20Reader.readTransportationStatus(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, TransportationStatusType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull File file) {
        return UBL20Reader.readTransportationStatus(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readTransportationStatus(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readTransportationStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readTransportationStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Source source) {
        return UBL20Reader.readTransportationStatus(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, TransportationStatusType.class, validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Node node) {
        return UBL20Reader.readWaybill(node, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(node, WaybillType.class, validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull File file) {
        return UBL20Reader.readWaybill(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readWaybill(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull IReadableResource iReadableResource) {
        return UBL20Reader.readWaybill((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Reader.readWaybill((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Source source) {
        return UBL20Reader.readWaybill(source, UBL20Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.readUBLDocument(source, WaybillType.class, validationEventHandler);
    }
}

