/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.error.IResourceErrorGroup;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.EUBL20DocumentType;
import com.helger.ubl.UBL20Marshaller;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.billoflading_2.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.catalogue_2.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_2.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_2.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_2.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_2.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_2.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_2.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_2.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_2.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_2.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.order_2.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_2.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_2.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_2.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_2.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_2.PackingListType;
import oasis.names.specification.ubl.schema.xsd.quotation_2.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_2.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_2.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_2.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_2.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_2.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_2.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_2.StatementType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_2.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.waybill_2.WaybillType;

@NotThreadSafe
public final class UBL20Validator
extends AbstractUBLDocumentMarshaller {
    private static final UBL20Validator s_aInstance = new UBL20Validator();

    private UBL20Validator() {
    }

    @Nullable
    public static IResourceErrorGroup validateApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL20Marshaller.validateUBLObject(applicationResponseType, EUBL20DocumentType.APPLICATION_RESPONSE);
    }

    public static boolean isValidApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL20Validator.validateApplicationResponse(applicationResponseType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL20Marshaller.validateUBLObject(attachedDocumentType, EUBL20DocumentType.ATTACHED_DOCUMENT);
    }

    public static boolean isValidAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL20Validator.validateAttachedDocument(attachedDocumentType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL20Marshaller.validateUBLObject(billOfLadingType, EUBL20DocumentType.BILL_OF_LADING);
    }

    public static boolean isValidBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL20Validator.validateBillOfLading(billOfLadingType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL20Marshaller.validateUBLObject(catalogueType, EUBL20DocumentType.CATALOGUE);
    }

    public static boolean isValidCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL20Validator.validateCatalogue(catalogueType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL20Marshaller.validateUBLObject(catalogueDeletionType, EUBL20DocumentType.CATALOGUE_DELETION);
    }

    public static boolean isValidCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL20Validator.validateCatalogueDeletion(catalogueDeletionType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL20Marshaller.validateUBLObject(catalogueItemSpecificationUpdateType, EUBL20DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE);
    }

    public static boolean isValidCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL20Validator.validateCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL20Marshaller.validateUBLObject(cataloguePricingUpdateType, EUBL20DocumentType.CATALOGUE_PRICING_UPDATE);
    }

    public static boolean isValidCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL20Validator.validateCataloguePricingUpdate(cataloguePricingUpdateType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL20Marshaller.validateUBLObject(catalogueRequestType, EUBL20DocumentType.CATALOGUE_REQUEST);
    }

    public static boolean isValidCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL20Validator.validateCatalogueRequest(catalogueRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL20Marshaller.validateUBLObject(certificateOfOriginType, EUBL20DocumentType.CERTIFICATE_OF_ORIGIN);
    }

    public static boolean isValidCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL20Validator.validateCertificateOfOrigin(certificateOfOriginType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL20Marshaller.validateUBLObject(creditNoteType, EUBL20DocumentType.CREDIT_NOTE);
    }

    public static boolean isValidCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL20Validator.validateCreditNote(creditNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL20Marshaller.validateUBLObject(debitNoteType, EUBL20DocumentType.DEBIT_NOTE);
    }

    public static boolean isValidDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL20Validator.validateDebitNote(debitNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL20Marshaller.validateUBLObject(despatchAdviceType, EUBL20DocumentType.DESPATCH_ADVICE);
    }

    public static boolean isValidDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL20Validator.validateDespatchAdvice(despatchAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL20Marshaller.validateUBLObject(forwardingInstructionsType, EUBL20DocumentType.FORWARDING_INSTRUCTIONS);
    }

    public static boolean isValidForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL20Validator.validateForwardingInstructions(forwardingInstructionsType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL20Marshaller.validateUBLObject(freightInvoiceType, EUBL20DocumentType.FREIGHT_INVOICE);
    }

    public static boolean isValidFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL20Validator.validateFreightInvoice(freightInvoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL20Marshaller.validateUBLObject(invoiceType, EUBL20DocumentType.INVOICE);
    }

    public static boolean isValidInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL20Validator.validateInvoice(invoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrder(@Nonnull OrderType orderType) {
        return UBL20Marshaller.validateUBLObject(orderType, EUBL20DocumentType.ORDER);
    }

    public static boolean isValidOrder(@Nonnull OrderType orderType) {
        return UBL20Validator.validateOrder(orderType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL20Marshaller.validateUBLObject(orderCancellationType, EUBL20DocumentType.ORDER_CANCELLATION);
    }

    public static boolean isValidOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL20Validator.validateOrderCancellation(orderCancellationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL20Marshaller.validateUBLObject(orderChangeType, EUBL20DocumentType.ORDER_CHANGE);
    }

    public static boolean isValidOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL20Validator.validateOrderChange(orderChangeType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL20Marshaller.validateUBLObject(orderResponseType, EUBL20DocumentType.ORDER_RESPONSE);
    }

    public static boolean isValidOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL20Validator.validateOrderResponse(orderResponseType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL20Marshaller.validateUBLObject(orderResponseSimpleType, EUBL20DocumentType.ORDER_RESPONSE_SIMPLE);
    }

    public static boolean isValidOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL20Validator.validateOrderResponseSimple(orderResponseSimpleType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validatePackingList(@Nonnull PackingListType packingListType) {
        return UBL20Marshaller.validateUBLObject(packingListType, EUBL20DocumentType.PACKING_LIST);
    }

    public static boolean isValidPackingList(@Nonnull PackingListType packingListType) {
        return UBL20Validator.validatePackingList(packingListType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateQuotation(@Nonnull QuotationType quotationType) {
        return UBL20Marshaller.validateUBLObject(quotationType, EUBL20DocumentType.QUOTATION);
    }

    public static boolean isValidQuotation(@Nonnull QuotationType quotationType) {
        return UBL20Validator.validateQuotation(quotationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL20Marshaller.validateUBLObject(receiptAdviceType, EUBL20DocumentType.RECEIPT_ADVICE);
    }

    public static boolean isValidReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL20Validator.validateReceiptAdvice(receiptAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateReminder(@Nonnull ReminderType reminderType) {
        return UBL20Marshaller.validateUBLObject(reminderType, EUBL20DocumentType.REMINDER);
    }

    public static boolean isValidReminder(@Nonnull ReminderType reminderType) {
        return UBL20Validator.validateReminder(reminderType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL20Marshaller.validateUBLObject(remittanceAdviceType, EUBL20DocumentType.REMITTANCE_ADVICE);
    }

    public static boolean isValidRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL20Validator.validateRemittanceAdvice(remittanceAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL20Marshaller.validateUBLObject(requestForQuotationType, EUBL20DocumentType.REQUEST_FOR_QUOTATION);
    }

    public static boolean isValidRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL20Validator.validateRequestForQuotation(requestForQuotationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL20Marshaller.validateUBLObject(selfBilledCreditNoteType, EUBL20DocumentType.SELF_BILLED_CREDIT_NOTE);
    }

    public static boolean isValidSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL20Validator.validateSelfBilledCreditNote(selfBilledCreditNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL20Marshaller.validateUBLObject(selfBilledInvoiceType, EUBL20DocumentType.SELF_BILLED_INVOICE);
    }

    public static boolean isValidSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL20Validator.validateSelfBilledInvoice(selfBilledInvoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateStatement(@Nonnull StatementType statementType) {
        return UBL20Marshaller.validateUBLObject(statementType, EUBL20DocumentType.STATEMENT);
    }

    public static boolean isValidStatement(@Nonnull StatementType statementType) {
        return UBL20Validator.validateStatement(statementType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL20Marshaller.validateUBLObject(transportationStatusType, EUBL20DocumentType.TRANSPORTATION_STATUS);
    }

    public static boolean isValidTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL20Validator.validateTransportationStatus(transportationStatusType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateWaybill(@Nonnull WaybillType waybillType) {
        return UBL20Marshaller.validateUBLObject(waybillType, EUBL20DocumentType.WAYBILL);
    }

    public static boolean isValidWaybill(@Nonnull WaybillType waybillType) {
        return UBL20Validator.validateWaybill(waybillType).containsNoError();
    }
}

