/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.state.ESuccess;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.EUBL20DocumentType;
import com.helger.ubl.UBL20Marshaller;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.billoflading_2.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.catalogue_2.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_2.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_2.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_2.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_2.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_2.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_2.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_2.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_2.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_2.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.order_2.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_2.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_2.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_2.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_2.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_2.PackingListType;
import oasis.names.specification.ubl.schema.xsd.quotation_2.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_2.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_2.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_2.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_2.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_2.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_2.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_2.StatementType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_2.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.waybill_2.WaybillType;
import org.w3c.dom.Document;

@NotThreadSafe
public final class UBL20Writer
extends AbstractUBLDocumentMarshaller {
    private static final UBL20Writer s_aInstance = new UBL20Writer();

    private UBL20Writer() {
    }

    @Nullable
    public static Document writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL20Writer.writeApplicationResponse(applicationResponseType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)applicationResponseType, EUBL20DocumentType.APPLICATION_RESPONSE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nonnull File file) {
        return UBL20Writer.writeApplicationResponse(applicationResponseType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeApplicationResponse(applicationResponseType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nonnull Result result) {
        return UBL20Writer.writeApplicationResponse(applicationResponseType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(applicationResponseType, EUBL20DocumentType.APPLICATION_RESPONSE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL20Writer.writeAttachedDocument(attachedDocumentType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)attachedDocumentType, EUBL20DocumentType.ATTACHED_DOCUMENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nonnull File file) {
        return UBL20Writer.writeAttachedDocument(attachedDocumentType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeAttachedDocument(attachedDocumentType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nonnull Result result) {
        return UBL20Writer.writeAttachedDocument(attachedDocumentType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(attachedDocumentType, EUBL20DocumentType.ATTACHED_DOCUMENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL20Writer.writeBillOfLading(billOfLadingType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)billOfLadingType, EUBL20DocumentType.BILL_OF_LADING, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nonnull File file) {
        return UBL20Writer.writeBillOfLading(billOfLadingType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeBillOfLading(billOfLadingType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nonnull Result result) {
        return UBL20Writer.writeBillOfLading(billOfLadingType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(billOfLadingType, EUBL20DocumentType.BILL_OF_LADING, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL20Writer.writeCatalogue(catalogueType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)catalogueType, EUBL20DocumentType.CATALOGUE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nonnull File file) {
        return UBL20Writer.writeCatalogue(catalogueType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCatalogue(catalogueType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nonnull Result result) {
        return UBL20Writer.writeCatalogue(catalogueType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(catalogueType, EUBL20DocumentType.CATALOGUE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL20Writer.writeCatalogueDeletion(catalogueDeletionType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)catalogueDeletionType, EUBL20DocumentType.CATALOGUE_DELETION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nonnull File file) {
        return UBL20Writer.writeCatalogueDeletion(catalogueDeletionType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCatalogueDeletion(catalogueDeletionType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nonnull Result result) {
        return UBL20Writer.writeCatalogueDeletion(catalogueDeletionType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(catalogueDeletionType, EUBL20DocumentType.CATALOGUE_DELETION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL20Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)catalogueItemSpecificationUpdateType, EUBL20DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nonnull File file) {
        return UBL20Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nonnull Result result) {
        return UBL20Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(catalogueItemSpecificationUpdateType, EUBL20DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL20Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)cataloguePricingUpdateType, EUBL20DocumentType.CATALOGUE_PRICING_UPDATE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nonnull File file) {
        return UBL20Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nonnull Result result) {
        return UBL20Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(cataloguePricingUpdateType, EUBL20DocumentType.CATALOGUE_PRICING_UPDATE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL20Writer.writeCatalogueRequest(catalogueRequestType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)catalogueRequestType, EUBL20DocumentType.CATALOGUE_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nonnull File file) {
        return UBL20Writer.writeCatalogueRequest(catalogueRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCatalogueRequest(catalogueRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nonnull Result result) {
        return UBL20Writer.writeCatalogueRequest(catalogueRequestType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(catalogueRequestType, EUBL20DocumentType.CATALOGUE_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL20Writer.writeCertificateOfOrigin(certificateOfOriginType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)certificateOfOriginType, EUBL20DocumentType.CERTIFICATE_OF_ORIGIN, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nonnull File file) {
        return UBL20Writer.writeCertificateOfOrigin(certificateOfOriginType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCertificateOfOrigin(certificateOfOriginType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nonnull Result result) {
        return UBL20Writer.writeCertificateOfOrigin(certificateOfOriginType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(certificateOfOriginType, EUBL20DocumentType.CERTIFICATE_OF_ORIGIN, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL20Writer.writeCreditNote(creditNoteType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)creditNoteType, EUBL20DocumentType.CREDIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nonnull File file) {
        return UBL20Writer.writeCreditNote(creditNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeCreditNote(creditNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nonnull Result result) {
        return UBL20Writer.writeCreditNote(creditNoteType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(creditNoteType, EUBL20DocumentType.CREDIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL20Writer.writeDebitNote(debitNoteType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)debitNoteType, EUBL20DocumentType.DEBIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nonnull File file) {
        return UBL20Writer.writeDebitNote(debitNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeDebitNote(debitNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nonnull Result result) {
        return UBL20Writer.writeDebitNote(debitNoteType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(debitNoteType, EUBL20DocumentType.DEBIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL20Writer.writeDespatchAdvice(despatchAdviceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)despatchAdviceType, EUBL20DocumentType.DESPATCH_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nonnull File file) {
        return UBL20Writer.writeDespatchAdvice(despatchAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeDespatchAdvice(despatchAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nonnull Result result) {
        return UBL20Writer.writeDespatchAdvice(despatchAdviceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(despatchAdviceType, EUBL20DocumentType.DESPATCH_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL20Writer.writeForwardingInstructions(forwardingInstructionsType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)forwardingInstructionsType, EUBL20DocumentType.FORWARDING_INSTRUCTIONS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nonnull File file) {
        return UBL20Writer.writeForwardingInstructions(forwardingInstructionsType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeForwardingInstructions(forwardingInstructionsType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nonnull Result result) {
        return UBL20Writer.writeForwardingInstructions(forwardingInstructionsType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(forwardingInstructionsType, EUBL20DocumentType.FORWARDING_INSTRUCTIONS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL20Writer.writeFreightInvoice(freightInvoiceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)freightInvoiceType, EUBL20DocumentType.FREIGHT_INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nonnull File file) {
        return UBL20Writer.writeFreightInvoice(freightInvoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeFreightInvoice(freightInvoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nonnull Result result) {
        return UBL20Writer.writeFreightInvoice(freightInvoiceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(freightInvoiceType, EUBL20DocumentType.FREIGHT_INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL20Writer.writeInvoice(invoiceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)invoiceType, EUBL20DocumentType.INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nonnull File file) {
        return UBL20Writer.writeInvoice(invoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeInvoice(invoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nonnull Result result) {
        return UBL20Writer.writeInvoice(invoiceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(invoiceType, EUBL20DocumentType.INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrder(@Nonnull OrderType orderType) {
        return UBL20Writer.writeOrder(orderType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)orderType, EUBL20DocumentType.ORDER, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nonnull File file) {
        return UBL20Writer.writeOrder(orderType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeOrder(orderType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nonnull Result result) {
        return UBL20Writer.writeOrder(orderType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(orderType, EUBL20DocumentType.ORDER, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL20Writer.writeOrderCancellation(orderCancellationType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)orderCancellationType, EUBL20DocumentType.ORDER_CANCELLATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nonnull File file) {
        return UBL20Writer.writeOrderCancellation(orderCancellationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeOrderCancellation(orderCancellationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nonnull Result result) {
        return UBL20Writer.writeOrderCancellation(orderCancellationType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(orderCancellationType, EUBL20DocumentType.ORDER_CANCELLATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL20Writer.writeOrderChange(orderChangeType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)orderChangeType, EUBL20DocumentType.ORDER_CHANGE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nonnull File file) {
        return UBL20Writer.writeOrderChange(orderChangeType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeOrderChange(orderChangeType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nonnull Result result) {
        return UBL20Writer.writeOrderChange(orderChangeType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(orderChangeType, EUBL20DocumentType.ORDER_CHANGE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL20Writer.writeOrderResponse(orderResponseType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)orderResponseType, EUBL20DocumentType.ORDER_RESPONSE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nonnull File file) {
        return UBL20Writer.writeOrderResponse(orderResponseType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeOrderResponse(orderResponseType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nonnull Result result) {
        return UBL20Writer.writeOrderResponse(orderResponseType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(orderResponseType, EUBL20DocumentType.ORDER_RESPONSE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL20Writer.writeOrderResponseSimple(orderResponseSimpleType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)orderResponseSimpleType, EUBL20DocumentType.ORDER_RESPONSE_SIMPLE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nonnull File file) {
        return UBL20Writer.writeOrderResponseSimple(orderResponseSimpleType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeOrderResponseSimple(orderResponseSimpleType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nonnull Result result) {
        return UBL20Writer.writeOrderResponseSimple(orderResponseSimpleType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(orderResponseSimpleType, EUBL20DocumentType.ORDER_RESPONSE_SIMPLE, validationEventHandler, result);
    }

    @Nullable
    public static Document writePackingList(@Nonnull PackingListType packingListType) {
        return UBL20Writer.writePackingList(packingListType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)packingListType, EUBL20DocumentType.PACKING_LIST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nonnull File file) {
        return UBL20Writer.writePackingList(packingListType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writePackingList(packingListType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nonnull Result result) {
        return UBL20Writer.writePackingList(packingListType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(packingListType, EUBL20DocumentType.PACKING_LIST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeQuotation(@Nonnull QuotationType quotationType) {
        return UBL20Writer.writeQuotation(quotationType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)quotationType, EUBL20DocumentType.QUOTATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nonnull File file) {
        return UBL20Writer.writeQuotation(quotationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeQuotation(quotationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nonnull Result result) {
        return UBL20Writer.writeQuotation(quotationType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(quotationType, EUBL20DocumentType.QUOTATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL20Writer.writeReceiptAdvice(receiptAdviceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)receiptAdviceType, EUBL20DocumentType.RECEIPT_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nonnull File file) {
        return UBL20Writer.writeReceiptAdvice(receiptAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeReceiptAdvice(receiptAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nonnull Result result) {
        return UBL20Writer.writeReceiptAdvice(receiptAdviceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(receiptAdviceType, EUBL20DocumentType.RECEIPT_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeReminder(@Nonnull ReminderType reminderType) {
        return UBL20Writer.writeReminder(reminderType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)reminderType, EUBL20DocumentType.REMINDER, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nonnull File file) {
        return UBL20Writer.writeReminder(reminderType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeReminder(reminderType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nonnull Result result) {
        return UBL20Writer.writeReminder(reminderType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(reminderType, EUBL20DocumentType.REMINDER, validationEventHandler, result);
    }

    @Nullable
    public static Document writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL20Writer.writeRemittanceAdvice(remittanceAdviceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)remittanceAdviceType, EUBL20DocumentType.REMITTANCE_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nonnull File file) {
        return UBL20Writer.writeRemittanceAdvice(remittanceAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeRemittanceAdvice(remittanceAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nonnull Result result) {
        return UBL20Writer.writeRemittanceAdvice(remittanceAdviceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(remittanceAdviceType, EUBL20DocumentType.REMITTANCE_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL20Writer.writeRequestForQuotation(requestForQuotationType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)requestForQuotationType, EUBL20DocumentType.REQUEST_FOR_QUOTATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nonnull File file) {
        return UBL20Writer.writeRequestForQuotation(requestForQuotationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeRequestForQuotation(requestForQuotationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nonnull Result result) {
        return UBL20Writer.writeRequestForQuotation(requestForQuotationType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(requestForQuotationType, EUBL20DocumentType.REQUEST_FOR_QUOTATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL20Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)selfBilledCreditNoteType, EUBL20DocumentType.SELF_BILLED_CREDIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nonnull File file) {
        return UBL20Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nonnull Result result) {
        return UBL20Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(selfBilledCreditNoteType, EUBL20DocumentType.SELF_BILLED_CREDIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL20Writer.writeSelfBilledInvoice(selfBilledInvoiceType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)selfBilledInvoiceType, EUBL20DocumentType.SELF_BILLED_INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nonnull File file) {
        return UBL20Writer.writeSelfBilledInvoice(selfBilledInvoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeSelfBilledInvoice(selfBilledInvoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nonnull Result result) {
        return UBL20Writer.writeSelfBilledInvoice(selfBilledInvoiceType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(selfBilledInvoiceType, EUBL20DocumentType.SELF_BILLED_INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeStatement(@Nonnull StatementType statementType) {
        return UBL20Writer.writeStatement(statementType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)statementType, EUBL20DocumentType.STATEMENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nonnull File file) {
        return UBL20Writer.writeStatement(statementType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeStatement(statementType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nonnull Result result) {
        return UBL20Writer.writeStatement(statementType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(statementType, EUBL20DocumentType.STATEMENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL20Writer.writeTransportationStatus(transportationStatusType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)transportationStatusType, EUBL20DocumentType.TRANSPORTATION_STATUS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nonnull File file) {
        return UBL20Writer.writeTransportationStatus(transportationStatusType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeTransportationStatus(transportationStatusType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nonnull Result result) {
        return UBL20Writer.writeTransportationStatus(transportationStatusType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(transportationStatusType, EUBL20DocumentType.TRANSPORTATION_STATUS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeWaybill(@Nonnull WaybillType waybillType) {
        return UBL20Writer.writeWaybill(waybillType, UBL20Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL20Marshaller.writeUBLDocument((Object)waybillType, EUBL20DocumentType.WAYBILL, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nonnull File file) {
        return UBL20Writer.writeWaybill(waybillType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL20Writer.writeWaybill(waybillType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nonnull Result result) {
        return UBL20Writer.writeWaybill(waybillType, UBL20Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL20Marshaller.writeUBLDocument(waybillType, EUBL20DocumentType.WAYBILL, validationEventHandler, result);
    }
}

