/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.annotations.ReturnsImmutableObject;
import com.helger.commons.collections.CollectionHelper;
import com.helger.ubl.EUBL21DocumentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL21DocumentTypes {
    private static final Map<String, EUBL21DocumentType> s_aNamespace2DocType = new HashMap<String, EUBL21DocumentType>();
    private static final Map<String, EUBL21DocumentType> s_aLocalName2DocType = new HashMap<String, EUBL21DocumentType>();
    private static final UBL21DocumentTypes s_aInstance;

    private UBL21DocumentTypes() {
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<String> getAllNamespaces() {
        return CollectionHelper.makeUnmodifiable(s_aNamespace2DocType.keySet());
    }

    @Nullable
    public static EUBL21DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return s_aNamespace2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<String> getAllLocalNames() {
        return CollectionHelper.makeUnmodifiable(s_aLocalName2DocType.keySet());
    }

    @Nullable
    public static EUBL21DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return s_aLocalName2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz != null) {
            for (EUBL21DocumentType eUBL21DocumentType : EUBL21DocumentType.values()) {
                if (!eUBL21DocumentType.getImplementationClass().equals(clazz)) continue;
                return eUBL21DocumentType.getSchema();
            }
        }
        return null;
    }

    static {
        for (EUBL21DocumentType eUBL21DocumentType : EUBL21DocumentType.values()) {
            String string = eUBL21DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey(string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put(string, eUBL21DocumentType);
            String string2 = eUBL21DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey(string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put(string2, eUBL21DocumentType);
        }
        s_aInstance = new UBL21DocumentTypes();
    }
}

