/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.jaxb.JAXBContextCache;
import com.helger.commons.jaxb.JAXBMarshallerUtils;
import com.helger.commons.jaxb.validation.CollectingValidationEventHandler;
import com.helger.commons.jaxb.validation.LoggingValidationEventHandler;
import com.helger.commons.state.ESuccess;
import com.helger.commons.xml.XMLFactory;
import com.helger.commons.xml.XMLHelper;
import com.helger.ubl.EUBL21DocumentType;
import com.helger.ubl.UBL21DocumentTypes;
import com.helger.ubl.UBL21NamespacePrefixMapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

@Immutable
public final class UBL21Marshaller {
    private static final Logger s_aLogger = LoggerFactory.getLogger(UBL21Marshaller.class);
    private static final UBL21Marshaller s_aInstance = new UBL21Marshaller();

    private UBL21Marshaller() {
    }

    @Nonnull
    private static Unmarshaller _createUnmarshaller(@Nonnull Class<?> clazz, @Nonnull Schema schema, @Nullable ValidationEventHandler validationEventHandler) throws JAXBException {
        JAXBContext jAXBContext = JAXBContextCache.getInstance().getFromCache(clazz);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)(validationEventHandler != null ? validationEventHandler : new LoggingValidationEventHandler(unmarshaller.getEventHandler())));
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    @Nullable
    public static <T> T readUBLDocument(@Nonnull Node node, @Nonnull Class<T> clazz) {
        return UBL21Marshaller.readUBLDocument(node, clazz, null);
    }

    @Nullable
    public static <T> T readUBLDocument(@Nonnull Node node, @Nonnull Class<T> clazz, @Nullable ValidationEventHandler validationEventHandler) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (clazz == null) {
            throw new NullPointerException("destClass");
        }
        Object object = null;
        try {
            String string = XMLHelper.getNamespaceURI((Node)node);
            Class<?> clazz2 = UBL21DocumentTypes.getImplementationClassOfNamespace(string);
            if (!clazz.equals(clazz2)) {
                s_aLogger.error("You cannot read an '" + string + "' as a " + clazz.getName());
                return null;
            }
            Schema schema = UBL21DocumentTypes.getSchemaOfNamespace(string);
            Unmarshaller unmarshaller = UBL21Marshaller._createUnmarshaller(clazz2, schema, validationEventHandler);
            object = unmarshaller.unmarshal(node, clazz).getValue();
            if (object == null) {
                throw new IllegalStateException("Failed to read UBL 2.1 document of class " + clazz.getName() + " - without exception!");
            }
        }
        catch (UnmarshalException unmarshalException) {
            s_aLogger.error("Unmarshal exception reading UBL 2.1 document", (Throwable)unmarshalException);
            return null;
        }
        catch (JAXBException jAXBException) {
            s_aLogger.warn("JAXB Exception reading UBL 2.1 document", (Throwable)jAXBException);
            return null;
        }
        return (T)object;
    }

    @Nullable
    public static <T> T readUBLDocument(@Nonnull Source source, @Nonnull Class<T> clazz) {
        return UBL21Marshaller.readUBLDocument(source, clazz, null);
    }

    @Nullable
    public static <T> T readUBLDocument(@Nonnull Source source, @Nonnull Class<T> clazz, @Nullable ValidationEventHandler validationEventHandler) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (clazz == null) {
            throw new NullPointerException("destClass");
        }
        Object object = null;
        try {
            Schema schema = UBL21DocumentTypes.getSchemaOfImplementationClass(clazz);
            if (schema == null) {
                s_aLogger.error("Don't know how to read UBL object of class " + clazz.getName());
                return null;
            }
            Unmarshaller unmarshaller = UBL21Marshaller._createUnmarshaller(clazz, schema, validationEventHandler);
            object = unmarshaller.unmarshal(source, clazz).getValue();
            if (object == null) {
                throw new IllegalStateException("Failed to read UBL 2.1 document of class " + clazz.getName() + " - without exception!");
            }
        }
        catch (UnmarshalException unmarshalException) {
            s_aLogger.error("Unmarshal exception reading UBL 2.1 document", (Throwable)unmarshalException);
            return null;
        }
        catch (JAXBException jAXBException) {
            s_aLogger.warn("JAXB Exception reading UBL 2.1 document", (Throwable)jAXBException);
            return null;
        }
        return (T)object;
    }

    @Nonnull
    private static Marshaller _createMarshaller(@Nonnull Class<?> clazz, @Nonnull String string, @Nullable ValidationEventHandler validationEventHandler) throws JAXBException {
        JAXBContext jAXBContext = JAXBContextCache.getInstance().getFromCache(clazz);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setEventHandler((ValidationEventHandler)(validationEventHandler != null ? validationEventHandler : new LoggingValidationEventHandler(marshaller.getEventHandler())));
        marshaller.setSchema(UBL21DocumentTypes.getSchemaOfNamespace(string));
        if (JAXBMarshallerUtils.isSunJAXB2Marshaller((Marshaller)marshaller)) {
            try {
                JAXBMarshallerUtils.setSunNamespacePrefixMapper((Marshaller)marshaller, (Object)((Object)UBL21NamespacePrefixMapper.getInstance()));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                s_aLogger.warn("The com.sun.xml.bind:jaxb-impl artifact is missing in your classpath. Therefore no namespace mapping can be applied!");
            }
        }
        return marshaller;
    }

    @Nonnull
    private static JAXBElement<?> _createJAXBElement(@Nonnull QName qName, @Nonnull Object object) {
        return new JAXBElement(qName, object.getClass(), null, object);
    }

    @Nullable
    public static Document writeUBLDocument(@Nonnull Object object, @Nonnull EUBL21DocumentType eUBL21DocumentType) {
        return UBL21Marshaller.writeUBLDocument(object, eUBL21DocumentType, (ValidationEventHandler)null);
    }

    @Nullable
    public static Document writeUBLDocument(@Nonnull Object object, @Nonnull EUBL21DocumentType eUBL21DocumentType, @Nullable ValidationEventHandler validationEventHandler) {
        Document document = XMLFactory.newDocument();
        DOMResult dOMResult = new DOMResult(document);
        return UBL21Marshaller.writeUBLDocument(object, eUBL21DocumentType, validationEventHandler, dOMResult).isSuccess() ? document : null;
    }

    @Nonnull
    public static ESuccess writeUBLDocument(@Nonnull Object object, @Nonnull EUBL21DocumentType eUBL21DocumentType, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(object, eUBL21DocumentType, null, result);
    }

    @Nonnull
    public static ESuccess writeUBLDocument(@Nonnull Object object, @Nonnull EUBL21DocumentType eUBL21DocumentType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        if (object == null) {
            throw new NullPointerException("ublDocument");
        }
        if (eUBL21DocumentType == null) {
            throw new NullPointerException("docType");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        try {
            if (!eUBL21DocumentType.getPackage().equals(object.getClass().getPackage())) {
                s_aLogger.error("You cannot write a '" + object.getClass() + "' as a " + eUBL21DocumentType.getPackage().getName());
                return ESuccess.FAILURE;
            }
            Marshaller marshaller = UBL21Marshaller._createMarshaller(eUBL21DocumentType.getImplementationClass(), eUBL21DocumentType.getNamespaceURI(), validationEventHandler);
            JAXBElement<?> jAXBElement = UBL21Marshaller._createJAXBElement(eUBL21DocumentType.getQName(), object);
            marshaller.marshal(jAXBElement, result);
            return ESuccess.SUCCESS;
        }
        catch (MarshalException marshalException) {
            s_aLogger.error("Marshal exception writing UBL 2.1 document", (Throwable)marshalException);
        }
        catch (JAXBException jAXBException) {
            s_aLogger.warn("JAXB Exception writing UBL 2.1 document", (Throwable)jAXBException);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static IResourceErrorGroup validateUBLObject(@Nonnull Object object, @Nonnull EUBL21DocumentType eUBL21DocumentType) {
        if (object == null) {
            throw new NullPointerException("ublDocument");
        }
        if (eUBL21DocumentType == null) {
            throw new NullPointerException("docType");
        }
        CollectingValidationEventHandler collectingValidationEventHandler = new CollectingValidationEventHandler();
        try {
            if (!eUBL21DocumentType.getPackage().equals(object.getClass().getPackage())) {
                s_aLogger.error("You cannot validate a '" + object.getClass() + "' as a " + eUBL21DocumentType.getPackage().getName());
            } else {
                JAXBContext jAXBContext = JAXBContextCache.getInstance().getFromCache(eUBL21DocumentType.getImplementationClass());
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setEventHandler((ValidationEventHandler)collectingValidationEventHandler);
                marshaller.setSchema(UBL21DocumentTypes.getSchemaOfNamespace(eUBL21DocumentType.getNamespaceURI()));
                JAXBElement<?> jAXBElement = UBL21Marshaller._createJAXBElement(eUBL21DocumentType.getQName(), object);
                marshaller.marshal(jAXBElement, (ContentHandler)new DefaultHandler());
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return collectingValidationEventHandler.getResourceErrors();
    }
}

