/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.io.IReadableResource;
import com.helger.commons.xml.transform.TransformSourceFactory;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.UBL21Marshaller;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_21.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_21.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_21.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_21.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_21.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_21.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_21.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_21.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_21.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_21.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_21.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_21.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_21.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_21.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_21.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_21.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_21.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_21.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.forecast_21.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_21.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_21.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_21.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_21.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_21.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_21.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_21.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_21.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_21.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.order_21.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_21.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_21.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_21.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_21.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_21.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_21.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_21.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.quotation_21.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_21.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_21.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_21.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_21.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_21.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_21.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_21.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_21.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_21.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_21.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_21.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_21.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_21.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_21.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_21.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_21.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_21.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_21.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_21.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_21.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_21.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_21.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_21.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_21.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_21.WaybillType;
import org.w3c.dom.Node;

@NotThreadSafe
public final class UBL21Reader
extends AbstractUBLDocumentMarshaller {
    private static final UBL21Reader s_aInstance = new UBL21Reader();

    private UBL21Reader() {
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Node node) {
        return UBL21Reader.readApplicationResponse(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ApplicationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull File file) {
        return UBL21Reader.readApplicationResponse(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readApplicationResponse(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readApplicationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readApplicationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Source source) {
        return UBL21Reader.readApplicationResponse(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ApplicationResponseType readApplicationResponse(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ApplicationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Node node) {
        return UBL21Reader.readAttachedDocument(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, AttachedDocumentType.class, validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull File file) {
        return UBL21Reader.readAttachedDocument(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readAttachedDocument(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readAttachedDocument((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readAttachedDocument((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Source source) {
        return UBL21Reader.readAttachedDocument(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AttachedDocumentType readAttachedDocument(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, AttachedDocumentType.class, validationEventHandler);
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull Node node) {
        return UBL21Reader.readAwardedNotification(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, AwardedNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull File file) {
        return UBL21Reader.readAwardedNotification(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readAwardedNotification(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readAwardedNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readAwardedNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull Source source) {
        return UBL21Reader.readAwardedNotification(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static AwardedNotificationType readAwardedNotification(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, AwardedNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Node node) {
        return UBL21Reader.readBillOfLading(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, BillOfLadingType.class, validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull File file) {
        return UBL21Reader.readBillOfLading(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readBillOfLading(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readBillOfLading((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readBillOfLading((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Source source) {
        return UBL21Reader.readBillOfLading(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static BillOfLadingType readBillOfLading(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, BillOfLadingType.class, validationEventHandler);
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull Node node) {
        return UBL21Reader.readCallForTenders(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CallForTendersType.class, validationEventHandler);
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull File file) {
        return UBL21Reader.readCallForTenders(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCallForTenders(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCallForTenders((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCallForTenders((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull Source source) {
        return UBL21Reader.readCallForTenders(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CallForTendersType readCallForTenders(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CallForTendersType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Node node) {
        return UBL21Reader.readCatalogue(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CatalogueType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull File file) {
        return UBL21Reader.readCatalogue(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogue(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCatalogue((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogue((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Source source) {
        return UBL21Reader.readCatalogue(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueType readCatalogue(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CatalogueType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Node node) {
        return UBL21Reader.readCatalogueDeletion(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CatalogueDeletionType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull File file) {
        return UBL21Reader.readCatalogueDeletion(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueDeletion(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCatalogueDeletion((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueDeletion((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Source source) {
        return UBL21Reader.readCatalogueDeletion(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueDeletionType readCatalogueDeletion(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CatalogueDeletionType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Node node) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CatalogueItemSpecificationUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull File file) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Source source) {
        return UBL21Reader.readCatalogueItemSpecificationUpdate(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueItemSpecificationUpdateType readCatalogueItemSpecificationUpdate(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CatalogueItemSpecificationUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Node node) {
        return UBL21Reader.readCataloguePricingUpdate(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CataloguePricingUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull File file) {
        return UBL21Reader.readCataloguePricingUpdate(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCataloguePricingUpdate(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCataloguePricingUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCataloguePricingUpdate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Source source) {
        return UBL21Reader.readCataloguePricingUpdate(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CataloguePricingUpdateType readCataloguePricingUpdate(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CataloguePricingUpdateType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Node node) {
        return UBL21Reader.readCatalogueRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CatalogueRequestType.class, validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull File file) {
        return UBL21Reader.readCatalogueRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCatalogueRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCatalogueRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Source source) {
        return UBL21Reader.readCatalogueRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CatalogueRequestType readCatalogueRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CatalogueRequestType.class, validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Node node) {
        return UBL21Reader.readCertificateOfOrigin(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CertificateOfOriginType.class, validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull File file) {
        return UBL21Reader.readCertificateOfOrigin(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCertificateOfOrigin(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCertificateOfOrigin((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCertificateOfOrigin((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Source source) {
        return UBL21Reader.readCertificateOfOrigin(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CertificateOfOriginType readCertificateOfOrigin(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CertificateOfOriginType.class, validationEventHandler);
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull Node node) {
        return UBL21Reader.readContractAwardNotice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ContractAwardNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull File file) {
        return UBL21Reader.readContractAwardNotice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readContractAwardNotice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readContractAwardNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readContractAwardNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull Source source) {
        return UBL21Reader.readContractAwardNotice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ContractAwardNoticeType readContractAwardNotice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ContractAwardNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull Node node) {
        return UBL21Reader.readContractNotice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ContractNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull File file) {
        return UBL21Reader.readContractNotice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readContractNotice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readContractNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readContractNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull Source source) {
        return UBL21Reader.readContractNotice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ContractNoticeType readContractNotice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ContractNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Node node) {
        return UBL21Reader.readCreditNote(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, CreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull File file) {
        return UBL21Reader.readCreditNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCreditNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Source source) {
        return UBL21Reader.readCreditNote(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static CreditNoteType readCreditNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, CreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Node node) {
        return UBL21Reader.readDebitNote(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, DebitNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull File file) {
        return UBL21Reader.readDebitNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDebitNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readDebitNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDebitNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Source source) {
        return UBL21Reader.readDebitNote(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DebitNoteType readDebitNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, DebitNoteType.class, validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Node node) {
        return UBL21Reader.readDespatchAdvice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, DespatchAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull File file) {
        return UBL21Reader.readDespatchAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDespatchAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readDespatchAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDespatchAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Source source) {
        return UBL21Reader.readDespatchAdvice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DespatchAdviceType readDespatchAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, DespatchAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull Node node) {
        return UBL21Reader.readDocumentStatus(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, DocumentStatusType.class, validationEventHandler);
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull File file) {
        return UBL21Reader.readDocumentStatus(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDocumentStatus(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readDocumentStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDocumentStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull Source source) {
        return UBL21Reader.readDocumentStatus(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DocumentStatusType readDocumentStatus(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, DocumentStatusType.class, validationEventHandler);
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull Node node) {
        return UBL21Reader.readDocumentStatusRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, DocumentStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull File file) {
        return UBL21Reader.readDocumentStatusRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDocumentStatusRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readDocumentStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readDocumentStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull Source source) {
        return UBL21Reader.readDocumentStatusRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static DocumentStatusRequestType readDocumentStatusRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, DocumentStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull Node node) {
        return UBL21Reader.readExceptionCriteria(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ExceptionCriteriaType.class, validationEventHandler);
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull File file) {
        return UBL21Reader.readExceptionCriteria(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readExceptionCriteria(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readExceptionCriteria((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readExceptionCriteria((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull Source source) {
        return UBL21Reader.readExceptionCriteria(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ExceptionCriteriaType readExceptionCriteria(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ExceptionCriteriaType.class, validationEventHandler);
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull Node node) {
        return UBL21Reader.readExceptionNotification(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ExceptionNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull File file) {
        return UBL21Reader.readExceptionNotification(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readExceptionNotification(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readExceptionNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readExceptionNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull Source source) {
        return UBL21Reader.readExceptionNotification(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ExceptionNotificationType readExceptionNotification(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ExceptionNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull Node node) {
        return UBL21Reader.readForecast(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ForecastType.class, validationEventHandler);
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull File file) {
        return UBL21Reader.readForecast(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForecast(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readForecast((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForecast((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull Source source) {
        return UBL21Reader.readForecast(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForecastType readForecast(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ForecastType.class, validationEventHandler);
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull Node node) {
        return UBL21Reader.readForecastRevision(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ForecastRevisionType.class, validationEventHandler);
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull File file) {
        return UBL21Reader.readForecastRevision(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForecastRevision(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readForecastRevision((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForecastRevision((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull Source source) {
        return UBL21Reader.readForecastRevision(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForecastRevisionType readForecastRevision(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ForecastRevisionType.class, validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Node node) {
        return UBL21Reader.readForwardingInstructions(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ForwardingInstructionsType.class, validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull File file) {
        return UBL21Reader.readForwardingInstructions(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForwardingInstructions(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readForwardingInstructions((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readForwardingInstructions((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Source source) {
        return UBL21Reader.readForwardingInstructions(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ForwardingInstructionsType readForwardingInstructions(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ForwardingInstructionsType.class, validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Node node) {
        return UBL21Reader.readFreightInvoice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, FreightInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull File file) {
        return UBL21Reader.readFreightInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readFreightInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readFreightInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readFreightInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Source source) {
        return UBL21Reader.readFreightInvoice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FreightInvoiceType readFreightInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, FreightInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull Node node) {
        return UBL21Reader.readFulfilmentCancellation(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, FulfilmentCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull File file) {
        return UBL21Reader.readFulfilmentCancellation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readFulfilmentCancellation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readFulfilmentCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readFulfilmentCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull Source source) {
        return UBL21Reader.readFulfilmentCancellation(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static FulfilmentCancellationType readFulfilmentCancellation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, FulfilmentCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull Node node) {
        return UBL21Reader.readGoodsItemItinerary(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, GoodsItemItineraryType.class, validationEventHandler);
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull File file) {
        return UBL21Reader.readGoodsItemItinerary(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readGoodsItemItinerary(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readGoodsItemItinerary((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readGoodsItemItinerary((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull Source source) {
        return UBL21Reader.readGoodsItemItinerary(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static GoodsItemItineraryType readGoodsItemItinerary(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, GoodsItemItineraryType.class, validationEventHandler);
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull Node node) {
        return UBL21Reader.readGuaranteeCertificate(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, GuaranteeCertificateType.class, validationEventHandler);
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull File file) {
        return UBL21Reader.readGuaranteeCertificate(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readGuaranteeCertificate(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readGuaranteeCertificate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readGuaranteeCertificate((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull Source source) {
        return UBL21Reader.readGuaranteeCertificate(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static GuaranteeCertificateType readGuaranteeCertificate(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, GuaranteeCertificateType.class, validationEventHandler);
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull Node node) {
        return UBL21Reader.readInstructionForReturns(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, InstructionForReturnsType.class, validationEventHandler);
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull File file) {
        return UBL21Reader.readInstructionForReturns(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInstructionForReturns(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readInstructionForReturns((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInstructionForReturns((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull Source source) {
        return UBL21Reader.readInstructionForReturns(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InstructionForReturnsType readInstructionForReturns(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, InstructionForReturnsType.class, validationEventHandler);
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull Node node) {
        return UBL21Reader.readInventoryReport(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, InventoryReportType.class, validationEventHandler);
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull File file) {
        return UBL21Reader.readInventoryReport(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInventoryReport(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readInventoryReport((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInventoryReport((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull Source source) {
        return UBL21Reader.readInventoryReport(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InventoryReportType readInventoryReport(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, InventoryReportType.class, validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Node node) {
        return UBL21Reader.readInvoice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, InvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull File file) {
        return UBL21Reader.readInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Source source) {
        return UBL21Reader.readInvoice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static InvoiceType readInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, InvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull Node node) {
        return UBL21Reader.readItemInformationRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ItemInformationRequestType.class, validationEventHandler);
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull File file) {
        return UBL21Reader.readItemInformationRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readItemInformationRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readItemInformationRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readItemInformationRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull Source source) {
        return UBL21Reader.readItemInformationRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ItemInformationRequestType readItemInformationRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ItemInformationRequestType.class, validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Node node) {
        return UBL21Reader.readOrder(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, OrderType.class, validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull File file) {
        return UBL21Reader.readOrder(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderType readOrder(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrder(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readOrder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderType readOrder(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Source source) {
        return UBL21Reader.readOrder(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderType readOrder(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, OrderType.class, validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Node node) {
        return UBL21Reader.readOrderCancellation(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, OrderCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull File file) {
        return UBL21Reader.readOrderCancellation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderCancellation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readOrderCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderCancellation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Source source) {
        return UBL21Reader.readOrderCancellation(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderCancellationType readOrderCancellation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, OrderCancellationType.class, validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Node node) {
        return UBL21Reader.readOrderChange(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, OrderChangeType.class, validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull File file) {
        return UBL21Reader.readOrderChange(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderChange(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readOrderChange((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderChange((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Source source) {
        return UBL21Reader.readOrderChange(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderChangeType readOrderChange(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, OrderChangeType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Node node) {
        return UBL21Reader.readOrderResponse(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, OrderResponseType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull File file) {
        return UBL21Reader.readOrderResponse(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderResponse(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readOrderResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Source source) {
        return UBL21Reader.readOrderResponse(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseType readOrderResponse(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, OrderResponseType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Node node) {
        return UBL21Reader.readOrderResponseSimple(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, OrderResponseSimpleType.class, validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull File file) {
        return UBL21Reader.readOrderResponseSimple(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderResponseSimple(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readOrderResponseSimple((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readOrderResponseSimple((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Source source) {
        return UBL21Reader.readOrderResponseSimple(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static OrderResponseSimpleType readOrderResponseSimple(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, OrderResponseSimpleType.class, validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Node node) {
        return UBL21Reader.readPackingList(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, PackingListType.class, validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull File file) {
        return UBL21Reader.readPackingList(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readPackingList(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readPackingList((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readPackingList((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Source source) {
        return UBL21Reader.readPackingList(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PackingListType readPackingList(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, PackingListType.class, validationEventHandler);
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull Node node) {
        return UBL21Reader.readPriorInformationNotice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, PriorInformationNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull File file) {
        return UBL21Reader.readPriorInformationNotice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readPriorInformationNotice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readPriorInformationNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readPriorInformationNotice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull Source source) {
        return UBL21Reader.readPriorInformationNotice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static PriorInformationNoticeType readPriorInformationNotice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, PriorInformationNoticeType.class, validationEventHandler);
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull Node node) {
        return UBL21Reader.readProductActivity(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ProductActivityType.class, validationEventHandler);
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull File file) {
        return UBL21Reader.readProductActivity(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readProductActivity(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readProductActivity((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readProductActivity((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull Source source) {
        return UBL21Reader.readProductActivity(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ProductActivityType readProductActivity(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ProductActivityType.class, validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Node node) {
        return UBL21Reader.readQuotation(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, QuotationType.class, validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull File file) {
        return UBL21Reader.readQuotation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readQuotation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Source source) {
        return UBL21Reader.readQuotation(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static QuotationType readQuotation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, QuotationType.class, validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Node node) {
        return UBL21Reader.readReceiptAdvice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ReceiptAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull File file) {
        return UBL21Reader.readReceiptAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readReceiptAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readReceiptAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readReceiptAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Source source) {
        return UBL21Reader.readReceiptAdvice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReceiptAdviceType readReceiptAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ReceiptAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Node node) {
        return UBL21Reader.readReminder(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, ReminderType.class, validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull File file) {
        return UBL21Reader.readReminder(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readReminder(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readReminder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readReminder((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Source source) {
        return UBL21Reader.readReminder(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static ReminderType readReminder(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, ReminderType.class, validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Node node) {
        return UBL21Reader.readRemittanceAdvice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, RemittanceAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull File file) {
        return UBL21Reader.readRemittanceAdvice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRemittanceAdvice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readRemittanceAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRemittanceAdvice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Source source) {
        return UBL21Reader.readRemittanceAdvice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RemittanceAdviceType readRemittanceAdvice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, RemittanceAdviceType.class, validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Node node) {
        return UBL21Reader.readRequestForQuotation(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, RequestForQuotationType.class, validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull File file) {
        return UBL21Reader.readRequestForQuotation(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRequestForQuotation(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readRequestForQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRequestForQuotation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Source source) {
        return UBL21Reader.readRequestForQuotation(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RequestForQuotationType readRequestForQuotation(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, RequestForQuotationType.class, validationEventHandler);
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull Node node) {
        return UBL21Reader.readRetailEvent(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, RetailEventType.class, validationEventHandler);
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull File file) {
        return UBL21Reader.readRetailEvent(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRetailEvent(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readRetailEvent((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readRetailEvent((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull Source source) {
        return UBL21Reader.readRetailEvent(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static RetailEventType readRetailEvent(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, RetailEventType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Node node) {
        return UBL21Reader.readSelfBilledCreditNote(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, SelfBilledCreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull File file) {
        return UBL21Reader.readSelfBilledCreditNote(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readSelfBilledCreditNote(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readSelfBilledCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readSelfBilledCreditNote((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Source source) {
        return UBL21Reader.readSelfBilledCreditNote(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledCreditNoteType readSelfBilledCreditNote(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, SelfBilledCreditNoteType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Node node) {
        return UBL21Reader.readSelfBilledInvoice(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, SelfBilledInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull File file) {
        return UBL21Reader.readSelfBilledInvoice(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readSelfBilledInvoice(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readSelfBilledInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readSelfBilledInvoice((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Source source) {
        return UBL21Reader.readSelfBilledInvoice(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static SelfBilledInvoiceType readSelfBilledInvoice(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, SelfBilledInvoiceType.class, validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Node node) {
        return UBL21Reader.readStatement(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, StatementType.class, validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull File file) {
        return UBL21Reader.readStatement(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static StatementType readStatement(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readStatement(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static StatementType readStatement(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Source source) {
        return UBL21Reader.readStatement(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StatementType readStatement(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, StatementType.class, validationEventHandler);
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull Node node) {
        return UBL21Reader.readStockAvailabilityReport(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, StockAvailabilityReportType.class, validationEventHandler);
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull File file) {
        return UBL21Reader.readStockAvailabilityReport(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readStockAvailabilityReport(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readStockAvailabilityReport((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readStockAvailabilityReport((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull Source source) {
        return UBL21Reader.readStockAvailabilityReport(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static StockAvailabilityReportType readStockAvailabilityReport(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, StockAvailabilityReportType.class, validationEventHandler);
    }

    @Nullable
    public static TenderType readTender(@Nonnull Node node) {
        return UBL21Reader.readTender(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TenderType readTender(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TenderType.class, validationEventHandler);
    }

    @Nullable
    public static TenderType readTender(@Nonnull File file) {
        return UBL21Reader.readTender(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TenderType readTender(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTender(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TenderType readTender(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTender((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TenderType readTender(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTender((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TenderType readTender(@Nonnull Source source) {
        return UBL21Reader.readTender(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TenderType readTender(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TenderType.class, validationEventHandler);
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull Node node) {
        return UBL21Reader.readTendererQualification(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TendererQualificationType.class, validationEventHandler);
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull File file) {
        return UBL21Reader.readTendererQualification(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTendererQualification(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTendererQualification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTendererQualification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull Source source) {
        return UBL21Reader.readTendererQualification(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TendererQualificationType readTendererQualification(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TendererQualificationType.class, validationEventHandler);
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull Node node) {
        return UBL21Reader.readTendererQualificationResponse(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TendererQualificationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull File file) {
        return UBL21Reader.readTendererQualificationResponse(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTendererQualificationResponse(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTendererQualificationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTendererQualificationResponse((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull Source source) {
        return UBL21Reader.readTendererQualificationResponse(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TendererQualificationResponseType readTendererQualificationResponse(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TendererQualificationResponseType.class, validationEventHandler);
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull Node node) {
        return UBL21Reader.readTenderReceipt(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TenderReceiptType.class, validationEventHandler);
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull File file) {
        return UBL21Reader.readTenderReceipt(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTenderReceipt(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTenderReceipt((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTenderReceipt((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull Source source) {
        return UBL21Reader.readTenderReceipt(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TenderReceiptType readTenderReceipt(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TenderReceiptType.class, validationEventHandler);
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull Node node) {
        return UBL21Reader.readTradeItemLocationProfile(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TradeItemLocationProfileType.class, validationEventHandler);
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull File file) {
        return UBL21Reader.readTradeItemLocationProfile(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTradeItemLocationProfile(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTradeItemLocationProfile((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTradeItemLocationProfile((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull Source source) {
        return UBL21Reader.readTradeItemLocationProfile(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TradeItemLocationProfileType readTradeItemLocationProfile(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TradeItemLocationProfileType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Node node) {
        return UBL21Reader.readTransportationStatus(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportationStatusType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull File file) {
        return UBL21Reader.readTransportationStatus(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportationStatus(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportationStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportationStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Source source) {
        return UBL21Reader.readTransportationStatus(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusType readTransportationStatus(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportationStatusType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull Node node) {
        return UBL21Reader.readTransportationStatusRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportationStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull File file) {
        return UBL21Reader.readTransportationStatusRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportationStatusRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportationStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportationStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull Source source) {
        return UBL21Reader.readTransportationStatusRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportationStatusRequestType readTransportationStatusRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportationStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull Node node) {
        return UBL21Reader.readTransportExecutionPlan(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportExecutionPlanType.class, validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull File file) {
        return UBL21Reader.readTransportExecutionPlan(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportExecutionPlan(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportExecutionPlan((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportExecutionPlan((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull Source source) {
        return UBL21Reader.readTransportExecutionPlan(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportExecutionPlanType readTransportExecutionPlan(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportExecutionPlanType.class, validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull Node node) {
        return UBL21Reader.readTransportExecutionPlanRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportExecutionPlanRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull File file) {
        return UBL21Reader.readTransportExecutionPlanRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportExecutionPlanRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportExecutionPlanRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportExecutionPlanRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull Source source) {
        return UBL21Reader.readTransportExecutionPlanRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportExecutionPlanRequestType readTransportExecutionPlanRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportExecutionPlanRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull Node node) {
        return UBL21Reader.readTransportProgressStatus(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportProgressStatusType.class, validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull File file) {
        return UBL21Reader.readTransportProgressStatus(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportProgressStatus(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportProgressStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportProgressStatus((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull Source source) {
        return UBL21Reader.readTransportProgressStatus(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportProgressStatusType readTransportProgressStatus(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportProgressStatusType.class, validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull Node node) {
        return UBL21Reader.readTransportProgressStatusRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportProgressStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull File file) {
        return UBL21Reader.readTransportProgressStatusRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportProgressStatusRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportProgressStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportProgressStatusRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull Source source) {
        return UBL21Reader.readTransportProgressStatusRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportProgressStatusRequestType readTransportProgressStatusRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportProgressStatusRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull Node node) {
        return UBL21Reader.readTransportServiceDescription(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportServiceDescriptionType.class, validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull File file) {
        return UBL21Reader.readTransportServiceDescription(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportServiceDescription(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportServiceDescription((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportServiceDescription((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull Source source) {
        return UBL21Reader.readTransportServiceDescription(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportServiceDescriptionType readTransportServiceDescription(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportServiceDescriptionType.class, validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull Node node) {
        return UBL21Reader.readTransportServiceDescriptionRequest(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, TransportServiceDescriptionRequestType.class, validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull File file) {
        return UBL21Reader.readTransportServiceDescriptionRequest(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportServiceDescriptionRequest(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readTransportServiceDescriptionRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readTransportServiceDescriptionRequest((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull Source source) {
        return UBL21Reader.readTransportServiceDescriptionRequest(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static TransportServiceDescriptionRequestType readTransportServiceDescriptionRequest(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, TransportServiceDescriptionRequestType.class, validationEventHandler);
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull Node node) {
        return UBL21Reader.readUnawardedNotification(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, UnawardedNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull File file) {
        return UBL21Reader.readUnawardedNotification(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readUnawardedNotification(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readUnawardedNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readUnawardedNotification((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull Source source) {
        return UBL21Reader.readUnawardedNotification(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static UnawardedNotificationType readUnawardedNotification(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, UnawardedNotificationType.class, validationEventHandler);
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull Node node) {
        return UBL21Reader.readUtilityStatement(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, UtilityStatementType.class, validationEventHandler);
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull File file) {
        return UBL21Reader.readUtilityStatement(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readUtilityStatement(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readUtilityStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readUtilityStatement((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull Source source) {
        return UBL21Reader.readUtilityStatement(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static UtilityStatementType readUtilityStatement(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, UtilityStatementType.class, validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Node node) {
        return UBL21Reader.readWaybill(node, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Node node, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(node, WaybillType.class, validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull File file) {
        return UBL21Reader.readWaybill(TransformSourceFactory.create((File)file));
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull File file, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readWaybill(TransformSourceFactory.create((File)file), validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull IReadableResource iReadableResource) {
        return UBL21Reader.readWaybill((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull IReadableResource iReadableResource, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Reader.readWaybill((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), validationEventHandler);
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Source source) {
        return UBL21Reader.readWaybill(source, UBL21Reader.getGlobalValidationEventHandler());
    }

    @Nullable
    public static WaybillType readWaybill(@Nonnull Source source, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.readUBLDocument(source, WaybillType.class, validationEventHandler);
    }
}

