/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.error.IResourceErrorGroup;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.EUBL21DocumentType;
import com.helger.ubl.UBL21Marshaller;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_21.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_21.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_21.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_21.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_21.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_21.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_21.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_21.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_21.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_21.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_21.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_21.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_21.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_21.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_21.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_21.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_21.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_21.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.forecast_21.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_21.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_21.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_21.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_21.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_21.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_21.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_21.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_21.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_21.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.order_21.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_21.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_21.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_21.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_21.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_21.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_21.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_21.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.quotation_21.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_21.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_21.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_21.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_21.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_21.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_21.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_21.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_21.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_21.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_21.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_21.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_21.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_21.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_21.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_21.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_21.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_21.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_21.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_21.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_21.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_21.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_21.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_21.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_21.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_21.WaybillType;

@NotThreadSafe
public final class UBL21Validator
extends AbstractUBLDocumentMarshaller {
    private static final UBL21Validator s_aInstance = new UBL21Validator();

    private UBL21Validator() {
    }

    @Nullable
    public static IResourceErrorGroup validateApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL21Marshaller.validateUBLObject(applicationResponseType, EUBL21DocumentType.APPLICATION_RESPONSE);
    }

    public static boolean isValidApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL21Validator.validateApplicationResponse(applicationResponseType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL21Marshaller.validateUBLObject(attachedDocumentType, EUBL21DocumentType.ATTACHED_DOCUMENT);
    }

    public static boolean isValidAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL21Validator.validateAttachedDocument(attachedDocumentType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType) {
        return UBL21Marshaller.validateUBLObject(awardedNotificationType, EUBL21DocumentType.AWARDED_NOTIFICATION);
    }

    public static boolean isValidAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType) {
        return UBL21Validator.validateAwardedNotification(awardedNotificationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL21Marshaller.validateUBLObject(billOfLadingType, EUBL21DocumentType.BILL_OF_LADING);
    }

    public static boolean isValidBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL21Validator.validateBillOfLading(billOfLadingType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCallForTenders(@Nonnull CallForTendersType callForTendersType) {
        return UBL21Marshaller.validateUBLObject(callForTendersType, EUBL21DocumentType.CALL_FOR_TENDERS);
    }

    public static boolean isValidCallForTenders(@Nonnull CallForTendersType callForTendersType) {
        return UBL21Validator.validateCallForTenders(callForTendersType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL21Marshaller.validateUBLObject(catalogueType, EUBL21DocumentType.CATALOGUE);
    }

    public static boolean isValidCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL21Validator.validateCatalogue(catalogueType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL21Marshaller.validateUBLObject(catalogueDeletionType, EUBL21DocumentType.CATALOGUE_DELETION);
    }

    public static boolean isValidCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL21Validator.validateCatalogueDeletion(catalogueDeletionType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL21Marshaller.validateUBLObject(catalogueItemSpecificationUpdateType, EUBL21DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE);
    }

    public static boolean isValidCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL21Validator.validateCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL21Marshaller.validateUBLObject(cataloguePricingUpdateType, EUBL21DocumentType.CATALOGUE_PRICING_UPDATE);
    }

    public static boolean isValidCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL21Validator.validateCataloguePricingUpdate(cataloguePricingUpdateType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL21Marshaller.validateUBLObject(catalogueRequestType, EUBL21DocumentType.CATALOGUE_REQUEST);
    }

    public static boolean isValidCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL21Validator.validateCatalogueRequest(catalogueRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL21Marshaller.validateUBLObject(certificateOfOriginType, EUBL21DocumentType.CERTIFICATE_OF_ORIGIN);
    }

    public static boolean isValidCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL21Validator.validateCertificateOfOrigin(certificateOfOriginType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType) {
        return UBL21Marshaller.validateUBLObject(contractAwardNoticeType, EUBL21DocumentType.CONTRACT_AWARD_NOTICE);
    }

    public static boolean isValidContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType) {
        return UBL21Validator.validateContractAwardNotice(contractAwardNoticeType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateContractNotice(@Nonnull ContractNoticeType contractNoticeType) {
        return UBL21Marshaller.validateUBLObject(contractNoticeType, EUBL21DocumentType.CONTRACT_NOTICE);
    }

    public static boolean isValidContractNotice(@Nonnull ContractNoticeType contractNoticeType) {
        return UBL21Validator.validateContractNotice(contractNoticeType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL21Marshaller.validateUBLObject(creditNoteType, EUBL21DocumentType.CREDIT_NOTE);
    }

    public static boolean isValidCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL21Validator.validateCreditNote(creditNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL21Marshaller.validateUBLObject(debitNoteType, EUBL21DocumentType.DEBIT_NOTE);
    }

    public static boolean isValidDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL21Validator.validateDebitNote(debitNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL21Marshaller.validateUBLObject(despatchAdviceType, EUBL21DocumentType.DESPATCH_ADVICE);
    }

    public static boolean isValidDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL21Validator.validateDespatchAdvice(despatchAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDocumentStatus(@Nonnull DocumentStatusType documentStatusType) {
        return UBL21Marshaller.validateUBLObject(documentStatusType, EUBL21DocumentType.DOCUMENT_STATUS);
    }

    public static boolean isValidDocumentStatus(@Nonnull DocumentStatusType documentStatusType) {
        return UBL21Validator.validateDocumentStatus(documentStatusType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType) {
        return UBL21Marshaller.validateUBLObject(documentStatusRequestType, EUBL21DocumentType.DOCUMENT_STATUS_REQUEST);
    }

    public static boolean isValidDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType) {
        return UBL21Validator.validateDocumentStatusRequest(documentStatusRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType) {
        return UBL21Marshaller.validateUBLObject(exceptionCriteriaType, EUBL21DocumentType.EXCEPTION_CRITERIA);
    }

    public static boolean isValidExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType) {
        return UBL21Validator.validateExceptionCriteria(exceptionCriteriaType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType) {
        return UBL21Marshaller.validateUBLObject(exceptionNotificationType, EUBL21DocumentType.EXCEPTION_NOTIFICATION);
    }

    public static boolean isValidExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType) {
        return UBL21Validator.validateExceptionNotification(exceptionNotificationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateForecast(@Nonnull ForecastType forecastType) {
        return UBL21Marshaller.validateUBLObject(forecastType, EUBL21DocumentType.FORECAST);
    }

    public static boolean isValidForecast(@Nonnull ForecastType forecastType) {
        return UBL21Validator.validateForecast(forecastType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType) {
        return UBL21Marshaller.validateUBLObject(forecastRevisionType, EUBL21DocumentType.FORECAST_REVISION);
    }

    public static boolean isValidForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType) {
        return UBL21Validator.validateForecastRevision(forecastRevisionType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL21Marshaller.validateUBLObject(forwardingInstructionsType, EUBL21DocumentType.FORWARDING_INSTRUCTIONS);
    }

    public static boolean isValidForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL21Validator.validateForwardingInstructions(forwardingInstructionsType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL21Marshaller.validateUBLObject(freightInvoiceType, EUBL21DocumentType.FREIGHT_INVOICE);
    }

    public static boolean isValidFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL21Validator.validateFreightInvoice(freightInvoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType) {
        return UBL21Marshaller.validateUBLObject(fulfilmentCancellationType, EUBL21DocumentType.FULFILMENT_CANCELATION);
    }

    public static boolean isValidFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType) {
        return UBL21Validator.validateFulfilmentCancellation(fulfilmentCancellationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType) {
        return UBL21Marshaller.validateUBLObject(goodsItemItineraryType, EUBL21DocumentType.GOODS_ITEM_ITINERARY);
    }

    public static boolean isValidGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType) {
        return UBL21Validator.validateGoodsItemItinerary(goodsItemItineraryType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType) {
        return UBL21Marshaller.validateUBLObject(guaranteeCertificateType, EUBL21DocumentType.GUARANTEE_CERTIFICATE);
    }

    public static boolean isValidGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType) {
        return UBL21Validator.validateGuaranteeCertificate(guaranteeCertificateType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType) {
        return UBL21Marshaller.validateUBLObject(instructionForReturnsType, EUBL21DocumentType.INSTRUCTION_FOR_RETURNS);
    }

    public static boolean isValidInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType) {
        return UBL21Validator.validateInstructionForReturns(instructionForReturnsType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateInventoryReport(@Nonnull InventoryReportType inventoryReportType) {
        return UBL21Marshaller.validateUBLObject(inventoryReportType, EUBL21DocumentType.INVENTORY_REPORT);
    }

    public static boolean isValidInventoryReport(@Nonnull InventoryReportType inventoryReportType) {
        return UBL21Validator.validateInventoryReport(inventoryReportType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL21Marshaller.validateUBLObject(invoiceType, EUBL21DocumentType.INVOICE);
    }

    public static boolean isValidInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL21Validator.validateInvoice(invoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType) {
        return UBL21Marshaller.validateUBLObject(itemInformationRequestType, EUBL21DocumentType.ITEM_INFORMATION_REQUEST);
    }

    public static boolean isValidItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType) {
        return UBL21Validator.validateItemInformationRequest(itemInformationRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrder(@Nonnull OrderType orderType) {
        return UBL21Marshaller.validateUBLObject(orderType, EUBL21DocumentType.ORDER);
    }

    public static boolean isValidOrder(@Nonnull OrderType orderType) {
        return UBL21Validator.validateOrder(orderType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL21Marshaller.validateUBLObject(orderCancellationType, EUBL21DocumentType.ORDER_CANCELLATION);
    }

    public static boolean isValidOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL21Validator.validateOrderCancellation(orderCancellationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL21Marshaller.validateUBLObject(orderChangeType, EUBL21DocumentType.ORDER_CHANGE);
    }

    public static boolean isValidOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL21Validator.validateOrderChange(orderChangeType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL21Marshaller.validateUBLObject(orderResponseType, EUBL21DocumentType.ORDER_RESPONSE);
    }

    public static boolean isValidOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL21Validator.validateOrderResponse(orderResponseType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL21Marshaller.validateUBLObject(orderResponseSimpleType, EUBL21DocumentType.ORDER_RESPONSE_SIMPLE);
    }

    public static boolean isValidOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL21Validator.validateOrderResponseSimple(orderResponseSimpleType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validatePackingList(@Nonnull PackingListType packingListType) {
        return UBL21Marshaller.validateUBLObject(packingListType, EUBL21DocumentType.PACKING_LIST);
    }

    public static boolean isValidPackingList(@Nonnull PackingListType packingListType) {
        return UBL21Validator.validatePackingList(packingListType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validatePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType) {
        return UBL21Marshaller.validateUBLObject(priorInformationNoticeType, EUBL21DocumentType.PRIOR_INFORMATION_NOTICE);
    }

    public static boolean isValidPriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType) {
        return UBL21Validator.validatePriorInformationNotice(priorInformationNoticeType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateProductActivity(@Nonnull ProductActivityType productActivityType) {
        return UBL21Marshaller.validateUBLObject(productActivityType, EUBL21DocumentType.PRODUCT_ACTIVITY);
    }

    public static boolean isValidProductActivity(@Nonnull ProductActivityType productActivityType) {
        return UBL21Validator.validateProductActivity(productActivityType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateQuotation(@Nonnull QuotationType quotationType) {
        return UBL21Marshaller.validateUBLObject(quotationType, EUBL21DocumentType.QUOTATION);
    }

    public static boolean isValidQuotation(@Nonnull QuotationType quotationType) {
        return UBL21Validator.validateQuotation(quotationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL21Marshaller.validateUBLObject(receiptAdviceType, EUBL21DocumentType.RECEIPT_ADVICE);
    }

    public static boolean isValidReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL21Validator.validateReceiptAdvice(receiptAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateReminder(@Nonnull ReminderType reminderType) {
        return UBL21Marshaller.validateUBLObject(reminderType, EUBL21DocumentType.REMINDER);
    }

    public static boolean isValidReminder(@Nonnull ReminderType reminderType) {
        return UBL21Validator.validateReminder(reminderType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL21Marshaller.validateUBLObject(remittanceAdviceType, EUBL21DocumentType.REMITTANCE_ADVICE);
    }

    public static boolean isValidRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL21Validator.validateRemittanceAdvice(remittanceAdviceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL21Marshaller.validateUBLObject(requestForQuotationType, EUBL21DocumentType.REQUEST_FOR_QUOTATION);
    }

    public static boolean isValidRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL21Validator.validateRequestForQuotation(requestForQuotationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateRetailEvent(@Nonnull RetailEventType retailEventType) {
        return UBL21Marshaller.validateUBLObject(retailEventType, EUBL21DocumentType.RETAIL_EVENT);
    }

    public static boolean isValidRetailEvent(@Nonnull RetailEventType retailEventType) {
        return UBL21Validator.validateRetailEvent(retailEventType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL21Marshaller.validateUBLObject(selfBilledCreditNoteType, EUBL21DocumentType.SELF_BILLED_CREDIT_NOTE);
    }

    public static boolean isValidSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL21Validator.validateSelfBilledCreditNote(selfBilledCreditNoteType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL21Marshaller.validateUBLObject(selfBilledInvoiceType, EUBL21DocumentType.SELF_BILLED_INVOICE);
    }

    public static boolean isValidSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL21Validator.validateSelfBilledInvoice(selfBilledInvoiceType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateStatement(@Nonnull StatementType statementType) {
        return UBL21Marshaller.validateUBLObject(statementType, EUBL21DocumentType.STATEMENT);
    }

    public static boolean isValidStatement(@Nonnull StatementType statementType) {
        return UBL21Validator.validateStatement(statementType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType) {
        return UBL21Marshaller.validateUBLObject(stockAvailabilityReportType, EUBL21DocumentType.STOCK_AVAILABILITY_REPORT);
    }

    public static boolean isValidStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType) {
        return UBL21Validator.validateStockAvailabilityReport(stockAvailabilityReportType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTender(@Nonnull TenderType tenderType) {
        return UBL21Marshaller.validateUBLObject(tenderType, EUBL21DocumentType.TENDER);
    }

    public static boolean isValidTender(@Nonnull TenderType tenderType) {
        return UBL21Validator.validateTender(tenderType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTendererQualification(@Nonnull TendererQualificationType tendererQualificationType) {
        return UBL21Marshaller.validateUBLObject(tendererQualificationType, EUBL21DocumentType.TENDER_QUALIFICATION);
    }

    public static boolean isValidTendererQualification(@Nonnull TendererQualificationType tendererQualificationType) {
        return UBL21Validator.validateTendererQualification(tendererQualificationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType) {
        return UBL21Marshaller.validateUBLObject(tendererQualificationResponseType, EUBL21DocumentType.TENDER_QUALIFICATION_RESPONSE);
    }

    public static boolean isValidTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType) {
        return UBL21Validator.validateTendererQualificationResponse(tendererQualificationResponseType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType) {
        return UBL21Marshaller.validateUBLObject(tenderReceiptType, EUBL21DocumentType.TENDER_RECEIPT);
    }

    public static boolean isValidTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType) {
        return UBL21Validator.validateTenderReceipt(tenderReceiptType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType) {
        return UBL21Marshaller.validateUBLObject(tradeItemLocationProfileType, EUBL21DocumentType.TRADE_ITEM_LOCATION_PROFILE);
    }

    public static boolean isValidTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType) {
        return UBL21Validator.validateTradeItemLocationProfile(tradeItemLocationProfileType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL21Marshaller.validateUBLObject(transportationStatusType, EUBL21DocumentType.TRANSPORTATION_STATUS);
    }

    public static boolean isValidTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL21Validator.validateTransportationStatus(transportationStatusType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType) {
        return UBL21Marshaller.validateUBLObject(transportationStatusRequestType, EUBL21DocumentType.TRANSPORTATION_STATUS_REQUEST);
    }

    public static boolean isValidTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType) {
        return UBL21Validator.validateTransportationStatusRequest(transportationStatusRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType) {
        return UBL21Marshaller.validateUBLObject(transportExecutionPlanType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN);
    }

    public static boolean isValidTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType) {
        return UBL21Validator.validateTransportExecutionPlan(transportExecutionPlanType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType) {
        return UBL21Marshaller.validateUBLObject(transportExecutionPlanRequestType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN_REQUEST);
    }

    public static boolean isValidTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType) {
        return UBL21Validator.validateTransportExecutionPlanRequest(transportExecutionPlanRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType) {
        return UBL21Marshaller.validateUBLObject(transportProgressStatusType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS);
    }

    public static boolean isValidTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType) {
        return UBL21Validator.validateTransportProgressStatus(transportProgressStatusType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType) {
        return UBL21Marshaller.validateUBLObject(transportProgressStatusRequestType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS_REQUEST);
    }

    public static boolean isValidTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType) {
        return UBL21Validator.validateTransportProgressStatusRequest(transportProgressStatusRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType) {
        return UBL21Marshaller.validateUBLObject(transportServiceDescriptionType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION);
    }

    public static boolean isValidTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType) {
        return UBL21Validator.validateTransportServiceDescription(transportServiceDescriptionType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType) {
        return UBL21Marshaller.validateUBLObject(transportServiceDescriptionRequestType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION_REQUEST);
    }

    public static boolean isValidTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType) {
        return UBL21Validator.validateTransportServiceDescriptionRequest(transportServiceDescriptionRequestType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType) {
        return UBL21Marshaller.validateUBLObject(unawardedNotificationType, EUBL21DocumentType.UNAWARDED_NOTIFICATION);
    }

    public static boolean isValidUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType) {
        return UBL21Validator.validateUnawardedNotification(unawardedNotificationType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateUtilityStatement(@Nonnull UtilityStatementType utilityStatementType) {
        return UBL21Marshaller.validateUBLObject(utilityStatementType, EUBL21DocumentType.UTILITY_STATEMENT);
    }

    public static boolean isValidUtilityStatement(@Nonnull UtilityStatementType utilityStatementType) {
        return UBL21Validator.validateUtilityStatement(utilityStatementType).containsNoError();
    }

    @Nullable
    public static IResourceErrorGroup validateWaybill(@Nonnull WaybillType waybillType) {
        return UBL21Marshaller.validateUBLObject(waybillType, EUBL21DocumentType.WAYBILL);
    }

    public static boolean isValidWaybill(@Nonnull WaybillType waybillType) {
        return UBL21Validator.validateWaybill(waybillType).containsNoError();
    }
}

